package com.jshx.yzscw.yzscwqmjz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzscw.yzscwkmgl.service.YzscwkmglService;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglService;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglSfxxService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.math.BigDecimal;
import java.util.*;

public class YzscwqmjzAction extends BaseAction {

    /**
     * 主键ID列表，用于接收页面提交的多条主键ID信息
     */
    private String ids;

    private InputStream excelFile;

    private String fileName;

    private String startTerm;

    private String endTerm;

    /**
     * 实体类
     */
    private Yzscwpzgl yzscwpzgl = new Yzscwpzgl();

    private Yzscwkmgl yzscwkjkm = new Yzscwkmgl();

    private List<Yzscwkmgl> yzscwkjkmList = new ArrayList<>();

    private List<YzscwpzglSfxx> yzscwpzglSfxx = new ArrayList<>();
    /**
     * 业务类
     */
    @Autowired
    private YzscwpzglService yzscwpzglService;

    @Autowired
    private YzscwpzglSfxxService yzscwpzglSfxxService;

    @Autowired
    private YzscwkmglService yzscwkjkmService;

    /**
     * 修改新增标记，add为新增、mod为修改
     */
    private String flag;

    /**
     * 分页信息
     */
    private Pagination pagination;

    @Autowired()
    @Qualifier("sessionFactory")
    private SessionFactory sessionFactory;

//--------------------------------------------------------------

    public String monthInit() {

        return SUCCESS;
    }

    public String yearInit() {
        return SUCCESS;
    }

    public  String exportExcel() {

        return "exportExcel";
    }

    /**
     * 	初始化月末添加信息
     */
    public String initAdd() throws Exception{
        Map<String, Object> paraMap = new HashMap<>();
        // 此处startTerm为选择的所在年月
        if (StringUtils.isBlank(startTerm)) {
            this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "所在年月不可为空!" + "\"}");
        }

        //查询所在年月的凭证记录数
        paraMap.put("voucherNumber", startTerm +"%");
        List<Yzscwpzgl> pzglList = yzscwpzglService.findYzscwpzgl(paraMap);
        // 有数据
        String jzhTag = "";
        if (CollectionUtils.isNotEmpty(pzglList)) {
            //记字号
            String sequenceNumber = pzglList.get(0).getSequenceNumber();
            String billDate = pzglList.get(0).getBillDate();
            yzscwpzgl.setBillDate(billDate);
            DateTime dateTime = DateTime.parse(billDate);
            int i = dateTime.dayOfMonth().withMaximumValue().dayOfMonth().get();
            endTerm = billDate.substring(0, billDate.lastIndexOf("-")) +"-"+ i;
            jzhTag = (Integer.parseInt(sequenceNumber) + 1) +"";
            while ((jzhTag).length() < 4 ) {
                jzhTag = "0" + jzhTag;
            }
        } else {
            jzhTag = "0001";
        }
        Map<String, Object> paraMap1 = new HashMap<>();
        BigDecimal bigD = new BigDecimal("0.00");
        BigDecimal bigDCredit = new BigDecimal("0.00");
        if (StringUtils.isNotBlank(ids)) {
            List<String> id = new ArrayList<>();
            for (String s : ids.split(",")) {
                id.add(s.trim());
            }

            paraMap1.put("ids", id);
            List<Yzscwpzgl> list = yzscwpzglService.findYzscwpzgl(paraMap1);
            for (Yzscwpzgl pzgl : list) {
                bigD = bigD.add(new BigDecimal(pzgl.getAmount()));
                bigDCredit = bigDCredit.add(new BigDecimal(pzgl.getAmountCredit()));

                Map<String, Object> sfxxMap = new HashMap<>();
                sfxxMap.put("pzglId", pzgl.getId());
                List<YzscwpzglSfxx> sfxxes = yzscwpzglSfxxService.findYzscwpzglSfxx(sfxxMap);
                this.yzscwpzglSfxx.addAll(sfxxes);
            }
        }
        yzscwpzgl.setAmount(bigD.toString());
        yzscwpzgl.setAmountCredit(bigDCredit.toString());
        yzscwpzgl.setSequenceNumber(jzhTag);
        String userName = this.getLoginUser().getDisplayName();
        yzscwpzgl.setBillStaff(userName);
        //
        return EDIT;
    }

    /**
     * 	初始化年末结转添加信息
     */
    public String initAddForYear() throws Exception{
        Map<String, Object> paraMap = new HashMap<>();
        // 此处startTerm为选择的所在年月
        if (StringUtils.isBlank(startTerm)) {
            this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "所在年月不可为空!" + "\"}");
        }

        //查询所在年月的凭证记录数
        paraMap.put("voucherNumber", startTerm +"%");
        List<Yzscwpzgl> pzglList = yzscwpzglService.findYzscwpzgl(paraMap);
        // 有数据
        String jzhTag = "";
        if (CollectionUtils.isNotEmpty(pzglList)) {
            //记字号
            String sequenceNumber = pzglList.get(0).getSequenceNumber();
            String billDate = pzglList.get(0).getBillDate();
            yzscwpzgl.setBillDate(billDate);
            DateTime dateTime = DateTime.parse(billDate);
            int i = dateTime.dayOfMonth().withMaximumValue().dayOfMonth().get();
            endTerm = billDate.substring(0, billDate.lastIndexOf("-")) +"-"+ i;
            jzhTag = (Integer.parseInt(sequenceNumber) + 1) +"";
            while ((jzhTag).length() < 4 ) {
                jzhTag = "0" + jzhTag;
            }
        } else {
            jzhTag = "0001";
        }
        Map<String, Object> paraMap1 = new HashMap<>();
        BigDecimal bigD = new BigDecimal("0.00");
        BigDecimal bigDCredit = new BigDecimal("0.00");
        if (StringUtils.isNotBlank(ids)) {
            List<String> id = new ArrayList<>();
            for (String s : ids.split(",")) {
                id.add(s.trim());
            }

            paraMap1.put("ids", id);
            List<Yzscwpzgl> list = yzscwpzglService.findYzscwpzgl(paraMap1);
            for (Yzscwpzgl pzgl : list) {
                bigD = bigD.add(new BigDecimal(pzgl.getAmount()));
                bigDCredit = bigDCredit.add(new BigDecimal(pzgl.getAmountCredit()));
                Map<String, Object> sfxxMap = new HashMap<>();
                sfxxMap.put("pzglId", pzgl.getId());
                List<YzscwpzglSfxx> sfxxes = yzscwpzglSfxxService.findYzscwpzglSfxx(sfxxMap);
                this.yzscwpzglSfxx.addAll(sfxxes);
            }
        }
        yzscwpzgl.setAmount(bigD.toString());
        yzscwpzgl.setAmountCredit(bigDCredit.toString());
        yzscwpzgl.setSequenceNumber(jzhTag);
        String userName = this.getLoginUser().getDisplayName();
        yzscwpzgl.setBillStaff(userName);
        //
        return EDIT;
    }
    /**
     * 	跳转月末添加前选择页面
     */
    public String initBeforeAdd() throws Exception{
        Map<String, Object> paraMap = new HashMap<>();
        if (StringUtils.isNotBlank(ids)) {
            String[] split = ids.split(",");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < split.length; i++) {
                String s = split[i];
                sb.append(s.trim());
                sb.append(",");
            }
            String idStr = sb.toString();
            idStr = idStr.substring(0, idStr.length()-2);
            paraMap.put("ids", idStr);
            List<Yzscwpzgl> list = yzscwpzglService.findYzscwpzgl(paraMap);
//            Date accountDate = list.get(0).getAccountDate();

            for (Yzscwpzgl pzgl : list) {
                Map<String, Object> sfxxMap = new HashMap<>();
                sfxxMap.put("pzglId", pzgl.getId());
                List<YzscwpzglSfxx> sfxxes = yzscwpzglSfxxService.findYzscwpzglSfxx(sfxxMap);
                yzscwpzglSfxx.addAll(sfxxes);
            }
        }
        return EDIT;
    }
    /**
     * 	跳转年末添加前选择页面
     */
    public String initBeforeAddForYear() throws Exception{
        Map<String, Object> paraMap = new HashMap<>();
        if (StringUtils.isNotBlank(ids)) {
            paraMap.put("ids", ids);
            List<Yzscwpzgl> list = yzscwpzglService.findYzscwpzgl(paraMap);
            for (Yzscwpzgl pzgl : list) {
                Map<String, Object> sfxxMap = new HashMap<>();
                sfxxMap.put("pzglId", pzgl.getId());
                List<YzscwpzglSfxx> sfxxes = yzscwpzglSfxxService.findYzscwpzglSfxx(sfxxMap);
                yzscwpzglSfxx.addAll(sfxxes);
            }
        }
        return EDIT;
    }

    /**
     * 月末结转
     * @return
     */
    public String save () {
        if (null != yzscwpzgl) {
            yzscwpzgl.setDelFlag(0);
            //初始化状态
            yzscwpzgl.setVoucherStatus(0);
            //制单日期
            yzscwpzgl.setBillDate(yzscwpzgl.getBillDate());
            yzscwpzgl.setAccountDate(DateTime.parse(yzscwpzgl.getBillDate()).toDate());
            //来自页面手动添加
            yzscwpzgl.setInsertType(1);
//				String dateStr = DateTimeFormat.forPattern("yyyy-MM").print(LocalDate.now());
            //序列号与凭证号
            String dateStr = (yzscwpzgl.getBillDate().substring(0, 7));
            yzscwpzgl.setAboutDate(dateStr);
            yzscwpzgl.setVoucherNumber(dateStr+ "-" +yzscwpzgl.getSequenceNumber());
            yzscwpzgl.setInterestForMonth(2);
            yzscwpzgl.setInterestForYear(1);
            yzscwpzgl.setAccountSubject("1");
            if (yzscwpzgl.getAmountCredit().contains(",")) {
                String amountCredit = yzscwpzgl.getAmountCredit();
                amountCredit.replaceAll(",", "");
                yzscwpzgl.setAmountCredit(amountCredit);
            }
            if (yzscwpzgl.getAmount().contains(",")) {
                String amount = yzscwpzgl.getAmount();
                amount.replaceAll(",", "");
                yzscwpzgl.setAmount(amount);
            }
            List<YzscwpzglSfxx> sfxxes = new ArrayList<>();
            int tag = 0;
            try {
                yzscwpzglService.save(yzscwpzgl);
                //金额相关信息
                for (YzscwpzglSfxx sfxx : yzscwpzglSfxx) {
                    sfxx.setDelFlag(0);
                    sfxx.setVoucherNumber(yzscwpzgl.getVoucherNumber());
                    sfxx.setInsertType(1);
//                    sfxx.setSummary(yzscwpzgl.getSummary());
                    sfxx.setPzglId(yzscwpzgl.getId());
                    sfxxes.add(sfxx);
                }
                tag = 1;
                yzscwpzglService.saveSfxxByTransactionalForQmjz(sfxxes ,ids);

            }catch (Exception e) {
                String msg = (tag == 1 ? "保存凭证收费信息出错" : "保存凭证信息出错");
                logger.error("月度结转出错："+ msg, e.getMessage());
                e.printStackTrace();
            }
        }

        return RELOAD;
    }

    /**
     * 年末结转
     * @return
     */
    public String saveForYear () {
        if (null != yzscwpzgl) {
            yzscwpzgl.setDelFlag(0);
            //初始化状态
            yzscwpzgl.setVoucherStatus(0);
            //制单日期
            yzscwpzgl.setBillDate(yzscwpzgl.getBillDate());
            yzscwpzgl.setAccountDate(DateTime.parse(yzscwpzgl.getBillDate()).toDate());
            //来自页面手动添加
            yzscwpzgl.setInsertType(1);
//				String dateStr = DateTimeFormat.forPattern("yyyy-MM").print(LocalDate.now());
            //序列号与凭证号
            String dateStr = (yzscwpzgl.getBillDate().substring(0, 7));
            yzscwpzgl.setAboutDate(dateStr);
            yzscwpzgl.setVoucherNumber(dateStr+ "-" +yzscwpzgl.getSequenceNumber());
            yzscwpzgl.setInterestForMonth(3);
            yzscwpzgl.setInterestForYear(2);
            //年度结转完毕
            yzscwpzgl.setAccountSubject("2");
            if (yzscwpzgl.getAmountCredit().contains(",")) {
                String amountCredit = yzscwpzgl.getAmountCredit();
                amountCredit.replaceAll(",", "");
                yzscwpzgl.setAmountCredit(amountCredit);
            }
            if (yzscwpzgl.getAmount().contains(",")) {
                String amount = yzscwpzgl.getAmount();
                amount.replaceAll(",", "");
                yzscwpzgl.setAmount(amount);
            }
            List<YzscwpzglSfxx> sfxxes = new ArrayList<>();
            int tag = 0;
            try {
                yzscwpzglService.save(yzscwpzgl);
                //金额相关信息
                for (YzscwpzglSfxx sfxx : yzscwpzglSfxx) {
                    sfxx.setDelFlag(0);
                    sfxx.setVoucherNumber(yzscwpzgl.getVoucherNumber());
                    sfxx.setInsertType(1);
//                    sfxx.setSummary(yzscwpzgl.getSummary());
                    sfxx.setPzglId(yzscwpzgl.getId());
                    sfxxes.add(sfxx);
                }
                tag = 2;
                yzscwpzglService.saveSfxxByTransactionalForYear(sfxxes ,ids);

            }catch (Exception e) {
                String msg = (tag > 1 ? "保存凭证收费信息出错" : "保存凭证信息出错");
                logger.error("年度结转出错："+ msg, e.getMessage());
                e.printStackTrace();
            }
        }

        return RELOAD;
    }

    public void batchCarryOver() {
        Map<String, Object> paraMap = new HashMap<>();

    }



//-----------------getter & setter -----------------------------
    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public InputStream getExcelFile() {
        return excelFile;
    }

    public void setExcelFile(InputStream excelFile) {
        this.excelFile = excelFile;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getStartTerm() {
        return startTerm;
    }

    public void setStartTerm(String startTerm) {
        this.startTerm = startTerm;
    }

    public String getEndTerm() {
        return endTerm;
    }

    public void setEndTerm(String endTerm) {
        this.endTerm = endTerm;
    }

    public Yzscwpzgl getYzscwpzgl() {
        return yzscwpzgl;
    }

    public void setYzscwpzgl(Yzscwpzgl yzscwpzgl) {
        this.yzscwpzgl = yzscwpzgl;
    }

    public Yzscwkmgl getYzscwkjkm() {
        return yzscwkjkm;
    }

    public void setYzscwkjkm(Yzscwkmgl yzscwkjkm) {
        this.yzscwkjkm = yzscwkjkm;
    }

    public List<Yzscwkmgl> getYzscwkjkmList() {
        return yzscwkjkmList;
    }

    public void setYzscwkjkmList(List<Yzscwkmgl> yzscwkjkmList) {
        this.yzscwkjkmList = yzscwkjkmList;
    }

    public List<YzscwpzglSfxx> getYzscwpzglSfxx() {
        return yzscwpzglSfxx;
    }

    public void setYzscwpzglSfxx(List<YzscwpzglSfxx> yzscwpzglSfxx) {
        this.yzscwpzglSfxx = yzscwpzglSfxx;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }
}
