package com.jshx.yzscw.yzscwkmgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwkmgl.dao.YzscwkmglDao;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzssfgl.entity.Yzssfgl;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzscwkmglDao")
public class YzscwkmglDaoImpl extends BaseDaoImpl implements YzscwkmglDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzscwkmglByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzscwkmgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzscwkmglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwkmgl getById(String id)
	{
		return (Yzscwkmgl)this.getObjectById(Yzscwkmgl.class, id);
	}

	/**
	 * 保存信息
	 * @param yzscwkmgl 信息
	 */
	public void save(Yzscwkmgl yzscwkmgl)
	{
		yzscwkmgl.setId(null);
		this.saveOrUpdateObject(yzscwkmgl);
	}

	/**
	 * 修改信息
	 * @param yzscwkmgl 信息
	 */
	public void update(Yzscwkmgl yzscwkmgl)
	{
		this.saveOrUpdateObject(yzscwkmgl);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Yzssfgl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Yzscwkmgl yzscwkmgl = (Yzscwkmgl)this.getObjectById(Yzscwkmgl.class, id);
		yzscwkmgl.setDelFlag(1);
		this.saveObject(yzscwkmgl);
	}

	@Override
	public List<Yzscwkmgl> findKmListByParentKmdm(Map<String, Object> paraMap) {
		return this.findListByHqlId("findYzscwkmglByMap", paraMap);
	}

	@Override
	public Yzscwkmgl findKmglByKmdm(String s) {
		return (Yzscwkmgl)this.getObjectByProperty(Yzscwkmgl.class, "kmdm", s);
	}
}
