package com.jshx.yzscw.yzscwfzhskm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.yzscw.yzscwfzhskm.dao.YzscwfzhskmDao;
import com.jshx.yzscw.yzscwfzhskm.dao.YzscwkjkmYzscwfzhskmDao;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.entity.YzscwkjkmYzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.service.YzscwkjkmYzscwfzhskmService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzscwkjkmYzscwfzhskmService")
public class YzscwkjkmYzscwfzhskmServiceImpl extends BaseServiceImpl implements YzscwkjkmYzscwfzhskmService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzscwkjkmYzscwfzhskmDao")
	private YzscwkjkmYzscwfzhskmDao yzscwkjkmYzscwfzhskmDao;

	@Override
	public List<YzscwkjkmYzscwfzhskm> findYzscwkjkmYzscwfzhskm(Map<String, Object> paraMap) {
		return yzscwkjkmYzscwfzhskmDao.findYzscwkjkmYzscwfzhskm(paraMap);
	}

	@Transactional
	@Override
	public Map<String, String> findYzscwkjkmByFzhskmId(String fzhskmId) {
		Map<String, Object> paraMap = new HashMap<>();
		/*保存返回结果
		 * key 		辅助核算科目Id
		 * value	会计科目Id
		 */
		Map<String, String> valueMap = new HashMap<>();
		paraMap.put("fzhskmId", fzhskmId);

		List<YzscwkjkmYzscwfzhskm> yzscwkjkmYzscwfzhskm = yzscwkjkmYzscwfzhskmDao.findYzscwkjkmYzscwfzhskm(paraMap);
		for (YzscwkjkmYzscwfzhskm temp : yzscwkjkmYzscwfzhskm) {
			valueMap.put(temp.getKjkmId(), temp.getFzhskmId());
		}
		return valueMap;
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public YzscwkjkmYzscwfzhskm getById(String id)
	{
		return yzscwkjkmYzscwfzhskmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzscwkjkmYzscwfzhskm 信息
	 */
	@Transactional
	public void save(YzscwkjkmYzscwfzhskm yzscwkjkmYzscwfzhskm) {
		yzscwkjkmYzscwfzhskmDao.save(yzscwkjkmYzscwfzhskm);
	}

	/**
	 * 删除原有的关联记录,新增保存新的
	 * @param list
	 * @param fzhskmId
	 */
	@Transactional
	@Override
	public void saveNewAndDeleteOld(List<YzscwkjkmYzscwfzhskm> list, List<String> fzhskmIds) {
	    Map<String, Object> paraMap = new HashMap<>();
	    paraMap.put("fzhskmId", fzhskmIds);
	    //获取所有的辅助核算科目关联的记录;
        List<YzscwkjkmYzscwfzhskm> yzscwkjkmYzscwfzhskm1 = yzscwkjkmYzscwfzhskmDao.findYzscwkjkmYzscwfzhskm(paraMap);
        //循环删除所有关联的记录;
        for (YzscwkjkmYzscwfzhskm delTemp : yzscwkjkmYzscwfzhskm1) {
            yzscwkjkmYzscwfzhskmDao.deleteWithFlag(delTemp.getId());

        }
		/*for (String fzhskmId : fzhskmIds) {

		}*/
		// 循环保存新的
		for (YzscwkjkmYzscwfzhskm yzscwkjkmYzscwfzhskm : list) {
			yzscwkjkmYzscwfzhskmDao.save(yzscwkjkmYzscwfzhskm);
		}
	}

	/**
	 * 修改信息
	 * @param yzscwkjkmYzscwfzhskm 信息
	 */
	@Transactional
	public void update(YzscwkjkmYzscwfzhskm yzscwkjkmYzscwfzhskm)
	{
		yzscwkjkmYzscwfzhskmDao.update(yzscwkjkmYzscwfzhskm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids) {
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzscwkjkmYzscwfzhskmDao.findYzscwkjkmYzscwfzhskm(paraMap);
		yzscwkjkmYzscwfzhskmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(List<String> ids) {
		for (String id : ids) {
			yzscwkjkmYzscwfzhskmDao.deleteWithFlag(id);
		}
	}

}
