package com.jshx.xxjl.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.xxjl.dao.XxjlDao;
import com.jshx.xxjl.entity.Xxjl;
import com.jshx.xxjl.entity.Xxjlhis;
import com.jshx.xxjl.service.XxjlService;

@Service("xxjlService")
public class XxjlServiceImpl extends BaseServiceImpl implements XxjlService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("xxjlDao")
	private XxjlDao xxjlDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return xxjlDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xxjl getById(String id)
	{
		return xxjlDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Xxjl xxjl)
	{
		xxjlDao.save(xxjl);
	}
	@Override
	public void save(Xxjlhis model) {
		xxjlDao.save(model);
		
	}
	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Xxjl xxjl)
	{
		xxjlDao.update(xxjl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=xxjlDao.findXxjl(paraMap);
		
		xxjlDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    xxjlDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Xxjl getByxmbzj(String xmbzj) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		Xxjl Xxjl = (Xxjl)xxjlDao.findObjectByFieldsMap(Xxjl.class, paraMap);
		return Xxjl;
	}

	@Override
	public Xxjlhis getByXxjlhis(String xmbzj) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		Xxjlhis Xxjlhis = (Xxjlhis)xxjlDao.findObjectByFieldsMap(Xxjlhis.class, paraMap);
		return Xxjlhis;
	}

	@Override
	public List findxxjlList(Map<String, Object> paraMap) {
		return xxjlDao.findxxjlList(paraMap);
	}


}
