package com.jshx.xxjl.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xxjl.entity.Xxjl;
import com.jshx.xxjl.entity.Xxjlhis;
import com.jshx.xxjl.dao.XxjlDao;

@Component("xxjlDao")
public class XxjlDaoImpl extends BaseDaoImpl implements XxjlDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXxjlByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findXxjl(Map<String, Object> paraMap){
		return this.findListByHqlId("findXxjlByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xxjl getById(String id)
	{
		return (Xxjl)this.getObjectById(Xxjl.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xxjl xxjl)
	{
		xxjl.setId(null);
		this.saveOrUpdateObject(xxjl);
	}
	
	@Override
	public void save(Xxjlhis model) {
		model.setId(null);
		this.saveOrUpdateObject(model);
		
	}
	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xxjl xxjl)
	{
		this.saveOrUpdateObject(xxjl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Xxjl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Xxjl xxjl = (Xxjl)this.getObjectById(Xxjl.class, id);
		xxjl.setDelFlag(1);
		this.saveObject(xxjl);
	}

	@Override
	public List findxxjlList(Map<String, Object> paraMap) {
		return this.findListByHqlId("findXxjlByMap", paraMap);
	}


}
