package com.jshx.xmxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.dao.XmxxbDao;

@Component("xmxxbDao")
public class XmxxbDaoImpl extends BaseDaoImpl implements XmxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmxxbByMap", paraMap, page);
	}
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmxxbByMap1", paraMap, page);
	}
	public Pagination findByPage2(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmxxbByMap2", paraMap, page);
	}
	public Pagination findByPagehf(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmxxbByhf", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findXmxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findXmxxbByMap", paraMap);
	}
	@Override
	public Pagination findgdXmxxb(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findgdXmxxb", paraMap, page);
	}
	@Override
	public Pagination findXmxxbxg(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findxmxgXmxxb", paraMap, page);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmxxb getById(String id)
	{
		return (Xmxxb)this.getObjectById(Xmxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xmxxb xmxxb)
	{
		xmxxb.setId(null);
		this.saveOrUpdateObject(xmxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xmxxb xmxxb)
	{
		this.saveOrUpdateObject(xmxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Xmxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Xmxxb xmxxb = (Xmxxb)this.getObjectById(Xmxxb.class, id);
		xmxxb.setDelFlag(1);
		this.saveObject(xmxxb);
	}

	

	
}
