package com.jshx.xmdrb.dao.impl;

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2012-2014 Jiangsu Hongxin System Integration Co., Ltd.   */
/*                                                                        */
/* PROPRIETARY RIGHTS of Jiangsu Hongxin are involved in the 　　　　　　 */
/* subject matter of this material.  All manufacturing, reproduction, use,*/
/* and sales rights pertaining to this subject matter are governed by the */
/* license agreement. The recipient of this software implicitly accepts   */
/* the terms of the license.                                              */
/* 本软件文档资料是江苏鸿信公司的资产,任何人士阅读和使用本资料必须获得    */
/* 相应的书面授权,承担保密责任和接受相应的法律约束.                       */
/*                                                                        */
/**************************************************************************/

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.xmdrb.dao.GenericDao;

@Component("genericDao")
public class GenericDaoImpl<T, PK extends Serializable> extends BaseDaoImpl
		implements GenericDao<T, PK> {
	@Autowired()
	@Qualifier("sqlMapClient")
	private SqlMapClient sqlMapClient;

	/**
	 * 分页查询
	 * 
	 * @param page
	 *            分页信息
	 * @param paraMap
	 *            查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId(paraMap.get("HqlId").toString(), paraMap,
				page);
	}

	@Override
	public Object findClassById(Class class1, String id) {
		// TODO Auto-generated method stub
		return getObjectById(class1, id);
	}

	@Override
	public List<T> findListById(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return this.findListByHqlId(paraMap.get("HqlId").toString(), paraMap);
	}

	@Override
	public Object findClassByObject(Class class1, String name, String id) {
		// TODO Auto-generated method stub
		return getObjectByProperty(class1, name, id);
	}

	@Override
	public List<T> findListBySqlId(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(),
				paraMap);
		List list = new ArrayList();
		if (hsql != null) {
			StringBuffer buffHSQL = new StringBuffer(hsql);
			Query query = getSession().createSQLQuery(buffHSQL.toString())
					.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
			setQueryParameters(query, paraMap);
			list = query.list();
			return list;
		}
		return null;
	}

	@Override
	public Pagination findBySqlId(Pagination pagination,
			Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(),
				paraMap);
		String countSql = convertToCountSqlStatement(hsql);
		try {
			int count = 0;
			if (countSql != null) {
				Query countQuery = getSession().createSQLQuery(countSql);
				setQueryParameters(countQuery, paraMap);

				count = Integer.parseInt(countQuery.uniqueResult().toString());

				pagination.setTotalCount(count);
			}
			if ((hsql != null) && (count != 0)) {
				StringBuffer buffHSQL = new StringBuffer(hsql);

				Query query = getSession().createSQLQuery(buffHSQL.toString())
						.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
				setQueryParameters(query, paraMap);
				query.setFirstResult(pagination.getFirstResult());
				query.setMaxResults(pagination.getPageSize());

				List restList = query.list();

				pagination.setList(restList);
			} else {
				if (hsql == null)
					throw new BasalException(BasalException.ERROR,
							"未在 SqlMap配置文件中配置, ID为"
									+ paraMap.get("SqlId").toString()
									+ "的hql 语句");
				if (count == 0)
					pagination.setList(new ArrayList());
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BasalException(BasalException.ERROR, e.getCause()
					.getMessage());
		}

		return pagination;
	}

	@Override
	public List<T> findListByObject(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(),
				paraMap);
		if (hsql != null) {
			StringBuffer buffHSQL = new StringBuffer(hsql);
			Query query = getSession().createSQLQuery(buffHSQL.toString());
			setQueryParameters(query, paraMap);
			return query.list();
		}
		return null;
	}

	@Override
	public void update(T obj) {
		// TODO Auto-generated method stub
		getSession().update(obj);
	}

	public void saveOrUpdate(T entity) {
		getSession().merge(entity);
		getSession().flush();
	}

	@Override
	public void deleteWithFlag(String hql) {
		// TODO Auto-generated method stub
		getSession().createQuery(hql).executeUpdate();
	}

	@Override
	public Object getObjectByProperty(Class entity, String[] name,
			Object[] value) {
		Criteria criteria = getSession().createCriteria(entity);
		for (int i = 0; i < name.length; i++)
			criteria.add(Restrictions.eq(name[i], value[i]));
		criteria.setMaxResults(1);
		return criteria.uniqueResult();
	}

	@Override
	public void updateByHql(String hql) {
		// TODO Auto-generated method stub
		getSession().createQuery(hql).executeUpdate();
	}

	@Override
	public void saveOrUpdateByHql(T entity) {
		// TODO Auto-generated method stub
		getSession().saveOrUpdate(entity);
	}

	@Override
	public void updateByHql(Map paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("HqlId").toString(),
				paraMap);
		Query countQuery = getSession().createQuery(hsql);
		setQueryParameters(countQuery, paraMap);
		countQuery.executeUpdate();
	}

	@Override
	public void updateBySql(Map paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(),
				paraMap);
		Query countQuery = getSession().createSQLQuery(hsql);
		setQueryParameters(countQuery, paraMap);
		countQuery.executeUpdate();

	}

	public Object findObjectByCombinedSql(final Map paraMap) {
		Object restOject = null;
		String sql = this.getSqlStatementById(paraMap.get("SqlId").toString(),
				paraMap);
		if (null != sql) {
			// Prepare Query
			Query query = getSession().createSQLQuery(sql);
			setQueryParameters(query, paraMap);

			// Execute Query List
			List list = query.list();
			if (null != list && list.size() != 0)
				restOject = list.get(0);
		}
		return restOject;
	}

	@Override
	public void remove(T entity) {
		// TODO Auto-generated method stub
		getSession().delete(entity);
	}
}
