package com.jshx.xmcxb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.record.chart.FontBasisRecord;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.cjjlb.service.CjjlbService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.xmcxb.entity.Xmcxb;
import com.jshx.xmcxb.service.XmcxbService;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

public class XmcxbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Xmcxb xmcxb = new Xmcxb();

	/**
	 * 业务类
	 */
	@Autowired
	private XmcxbService xmcxbService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private ZsdwService zsdwService;
	  @Autowired
	    private FawenAttachService fawenAttachService;
		@Autowired
		private CjjlbService cjjlbService;
		  @Autowired
		    private IdentityService identityService;
		   @Autowired
		    protected RuntimeService runtimeService;
		   @Autowired
		    protected TaskService taskService;
		    @Autowired
		    private ActivitiService activitiService;
		    @Autowired
			private PaymentItemPendingService paymentItemPendingService;
		    @Autowired
			private CktzsService cktzsService;
		    @Autowired
			private JktzsService jktzsService;
			@Autowired
			private QtfymxService qtfymxService;
			 @Autowired
				private JkmxService jkmxService;
				@Autowired
				private SpjlbService spjlbService;
				@Autowired
				private SdjdService sdjdService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	private String xmxxbid;
	private String jbsqbz;
	private List<FawenAttach> attach;
	private List<File> file1 ;  
	 private List<String> file1FileName ;
	private String allFileName;
	private String originFileName;
	private String taskId;
	private String comment;
	private String caozuo;
	private String jktzs;
	private String dwmc;
	
	
	
	
	public String getJktzs() {
		return jktzs;
	}


	public void setJktzs(String jktzs) {
		this.jktzs = jktzs;
	}


	public String getDwmc() {
		return dwmc;
	}


	public void setDwmc(String dwmc) {
		this.dwmc = dwmc;
	}


	public String getCaozuo() {
		return caozuo;
	}


	public void setCaozuo(String caozuo) {
		this.caozuo = caozuo;
	}


	public String getComment() {
		return comment;
	}


	public void setComment(String comment) {
		this.comment = comment;
	}


	public String getTaskId() {
		return taskId;
	}


	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}


	public List<File> getFile1() {
		return file1;
	}


	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}


	public List<String> getFile1FileName() {
		return file1FileName;
	}


	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}


	public String getAllFileName() {
		return allFileName;
	}


	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}


	public String getOriginFileName() {
		return originFileName;
	}


	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}


	public String getJbsqbz() {
		return jbsqbz;
	}


	public void setJbsqbz(String jbsqbz) {
		this.jbsqbz = jbsqbz;
	}


	public List<FawenAttach> getAttach() {
		return attach;
	}


	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}


	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private Xmxxb xmxxb = new Xmxxb();
	private Date queryFhsjStart;

	private Date queryFhsjEnd;

	private Date queryShsjStart;

	private Date queryShsjEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != xmcxb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmcxb.getSlbh()) && (0 < xmcxb.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + xmcxb.getSlbh().trim() + "%");
			}

			if ((null != xmcxb.getDwdm()) && (0 < xmcxb.getDwdm().trim().length())){
				paraMap.put("dwdm", "%" + xmcxb.getDwdm().trim() + "%");
			}

			if ((null != xmcxb.getXxbbh()) && (0 < xmcxb.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + xmcxb.getXxbbh().trim() + "%");
			}

			if ((null != xmcxb.getSqr()) && (0 < xmcxb.getSqr().trim().length())){
				paraMap.put("sqr", "%" + xmcxb.getSqr().trim() + "%");
			}

			if ((null != xmcxb.getXmmc()) && (0 < xmcxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmcxb.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|fhr|fhsj|shr|shsj|slbh|xxbbh|xmmc|sqr|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmcxbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	
	
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != xmxxb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length())){
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length())){
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length())){
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}

		}
//	    	paraMap.put("issptg", "0");
//	    	paraMap.put("isxmcxnull", "2");
		   String dwdm="";
	         if(!this.getLoginUser().getIsSuperAdmin()){
	           dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
	         }
	         if(!"".equals(dwdm)){
	        	paraMap.put("dwdm", dwdm);
	         }
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|lianxiren|xkzh|zjzmjds|csje|xmmc|mjyj|yjmj|yjje|zjsmj|";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}
		pagination = xmcxbService.findByPage1(pagination, paraMap);
		pagination.setListOfObject(pagination.getList());
		convObjectToJson(pagination, config);
	}
	

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != xmcxb)&&(null != xmcxb.getId()))
			xmcxb = xmcxbService.getById(xmcxb.getId());
		
		return VIEW;
	}
	/**
	 * 综合查询查看详细信息
	 */
	public String view1() throws Exception{
		if((null != xmcxb)&&(null != xmcxb.getId())){
//			xmcxb = xmcxbService.getById(xmcxb.getId());
			Map<String, Object> para = new HashMap<String, Object>();
			para.put("slbh", xmcxb.getId());
			List<Xmcxb> lxs=xmcxbService.findall(para);
			List<Jktzs>jks=jktzsService.findByAll(para);
			
			if(lxs.size()>0){
				xmcxb=lxs.get(0);
			}
			if(jks.size()>0){
				jktzs=jks.get(0).getDzbh();
				dwmc=jks.get(0).getDzbh();
			}
		}
		return VIEW;
	}
	/**
	 * 项目撤销经办
	 */
	public String xmcxjb() throws Exception{
		if((null != xmxxbid)&&(null != xmxxbid)){
			xmxxb = xmxxbService.getById(xmxxbid);
			Map<String, Object> para = new HashMap<String, Object>();
			para.put("xmbzj", xmxxbid);
			List<Jktzs> jks=jktzsService.findByAll(para);
			Jktzs jk=new Jktzs();
			String csje="0";
			if(jks.size()>0){
				jk=jks.get(0);
				csje=SysPropertiesUtil.add(jk.getJfje(), jk.getMjje());
			}
			this.setRequestAttribute("csje", csje);
			this.setRequestAttribute("jktzs", jk);
             
		}
		
		
//		 Map<String, String> paramMap = new HashMap<String, String>();
//			paramMap.put("bizrowid", xmxxb.getId());
//			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			xmxxb = xmxxbService.getById(xmxxb.getId());
			 Map<String, String> paraMap = new HashMap<String, String>();
			 
				//将附件相关信息放到附件表中

			    String path = SysPropertiesUtil.jdlj(this.getRequest())
						+ File.separator+ "uploads" +File.separator+xmxxb.getSlbh()+File.separator;
//		        String path = this.getRequest().getSession().getServletContext()
//						.getRealPath(File.separator)
//						+ File.separator+ "uploads" +File.separator+xmxxb.getSlbh()+File.separator;
		     // 写到指定的路径中  
		        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
							  String attachType = jsonObject.getString(file1FileName.get(i));
//							  String clno = fawenAttachService.getByFscl(attachType,"项目撤销");
							  String clno = fawenAttachService.getByFscl(attachType);
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  paraMap.put("attachType", attachType);
							  paraMap.put("bizrowid", xmxxb.getId());
//							  paraMap.put("xmType", "项目撤销");
							 List list = fawenAttachService.queryAttachListByTempleId(paraMap);
							 if(list.size()>0)
							 {
								 FawenAttach fawenAttach = (FawenAttach) list.get(0);
								 fawenAttach.setAttachname(file1FileName.get(i));
								 fawenAttach.setAttachpath(xmxxb.getSlbh()+File.separator+fileName);
								 if(StringUtils.isNotEmpty(clno))
									{
									 	fawenAttach.setXmType("缴费受理");
									}else
									{
										fawenAttach.setXmType("项目撤销");
									}
								 fawenAttach.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(fawenAttach);
							 }
							 else
							 {
							  FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath(xmxxb.getSlbh()+File.separator+fileName);
								att.setBizrowid(xmxxb.getId());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
								 if(StringUtils.isNotEmpty(clno))
									{
									 att.setXmType("缴费受理");
									}else
									{
										att.setXmType("项目撤销");
									}
								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
							 }
					             
					              
					        } 	
						}
			 
			xmcxb.setDeptId(this.getLoginUserDepartmentId());
			xmcxb.setDelFlag(0);
			xmcxb.setSqbz(jbsqbz);
			xmcxb.setSqr(this.getLoginUser().getDisplayName());
			xmcxb.setXmbzj(xmxxb.getId());
			xmcxb.setXmmc(xmxxb.getXmmc());
			xmcxb.setSlbh(xmxxb.getSlbh());
			xmcxb.setDwdm(xmxxb.getDwdm());
			xmcxb.setXxbbh(xmxxb.getXxylb());
		    
			xmxxb.setIsxmcx("0");
			
		      try {
		          identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
		          ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("xmcx", xmxxb.getId());
		          String aaa=processInstance.getProcessInstanceId();
		          xmcxb.setGzlid(aaa);
		      
		      } finally {
		          identityService.setAuthenticatedUserId(null);
		      }
			xmcxbService.save(xmcxb);
			xmxxbService.update(xmxxb);
		}else{
			xmcxbService.update(xmcxb);
		}
		
		return RELOAD;
	}
	
	//fhtg
	
	//复核调转
	public  String cxfh(){
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
		String businessKey =  processInstance.getBusinessKey();
		xmxxb=xmxxbService.getById(businessKey);
		
		 Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", xmxxb.getId());
//			paramMap.put("attachType", "市规划局注销行政许可决定书");
//			paramMap.put("xmType", "项目撤销");
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
			
			
			Map<String, Object> para = new HashMap<String, Object>();
			para.put("xmbzj", xmxxb.getId());
			List<Jktzs> jks=jktzsService.findByAll(para);
			List<Xmcxb> lcs=xmcxbService.findall(para);
			if(lcs.size()>0){
				this.setRequestAttribute("xmcxb", lcs.get(0));
			}
			
			Jktzs jk=new Jktzs();
			String csje="0";
			if(jks.size()>0){
				jk=jks.get(0);
				csje=SysPropertiesUtil.add(jk.getJfje(), jk.getMjje());
			}
			this.setRequestAttribute("csje", csje);
			this.setRequestAttribute("jktzs", jk);
//		cjjlb=cjjlbService.getById(businessKey);
//				
//		Map<String, Object> paraMap = new HashMap<String, Object>();
//		paraMap.put("xmbzj", cjjlb.getXmxxbzj() );
//		List<Cktzs> li=cktzsService.findByall1(paraMap);
//		   cktzs=li.get(0);
		return SUCCESS;
	}
	//复核通过
	public void fhtg() throws Exception{
	    try {
	        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	        String businessKey =  processInstance.getBusinessKey();
	        xmxxb=xmxxbService.getById(businessKey);
	        Map<String, Object> paraMap = new HashMap<String, Object>();
	        paraMap.put("slbh", xmxxb.getSlbh().trim());
	        List<Xmcxb> lx=xmcxbService.findall(paraMap);
	        if(lx.size()>0){
	        	xmcxb=xmcxbService.getById(lx.get(0).getId());
	        	xmcxb.setFhr(this.getLoginUser().getDisplayName());
	        	xmcxb.setFhsj(new Date());
	        	xmcxb.setFhyj(comment);
	        	xmcxbService.update(xmcxb);
	        }
	        activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            if("1".equals(caozuo)){
              runtimeService.deleteProcessInstance(xmcxb.getGzlid(), "人工终止");
              xmxxb.setIsxmcx("2");
              xmxxbService.update(xmxxb);
            }else{
            	taskService.complete(taskId);
            }             		
	        this.getResponse().getWriter().println("{\"result\":true}");
	    }catch (Exception e) {
	        this.getResponse().getWriter().println("{\"result\":false}");
	    }
	}
	//审核调转
	public  String cxsh(){
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
		String businessKey =  processInstance.getBusinessKey();
		xmxxb=xmxxbService.getById(businessKey);
		
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", xmxxb.getId());
//		paramMap.put("xmType", "项目撤销");
//		paramMap.put("attachType", "市规划局注销行政许可决定书");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		
		Map<String, Object> para = new HashMap<String, Object>();
		para.put("xmbzj", xmxxb.getId());
		List<Jktzs> jks=jktzsService.findByAll(para);
		List<Xmcxb> lcs=xmcxbService.findall(para);
		if(lcs.size()>0){
			this.setRequestAttribute("xmcxb", lcs.get(0));
		}
		
		Jktzs jk=new Jktzs();
		String csje="0";
		if(jks.size()>0){
			jk=jks.get(0);
			csje=SysPropertiesUtil.add(jk.getJfje(), jk.getMjje());
		}
		this.setRequestAttribute("csje", csje);
		this.setRequestAttribute("jktzs", jk);
		

		return SUCCESS;
	}
	//审核核通过
	public void shtg() throws Exception{
		try {
			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			xmxxb=xmxxbService.getById(businessKey);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", xmxxb.getSlbh().trim());
			List<Xmcxb> lx=xmcxbService.findall(paraMap);
			if(lx.size()>0){
				xmcxb=xmcxbService.getById(lx.get(0).getId());
				xmcxb.setShr(this.getLoginUser().getDisplayName());
				xmcxb.setShsj(new Date());
				xmcxb.setShyj(comment);
				xmcxbService.update(xmcxb);
			}
			
			
			
			activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
			   Map<String, Object> variables = new HashMap<String, Object>();
		          if("0".equals(caozuo)){
		        	//确认
		         	variables.put("sypd", "0");
		         		xmxxb.setIsxmcx("1");
		         		String yxxb=xmxxb.getXxylb();
		         		String xxbbh=xmxxb.getXxylb()+"(撤销)";
		         		xmxxb.setXxylb(xxbbh);
		         		xmxxbService.update(xmxxb);
		         		Map<String, Object> vad = new HashMap<String, Object>();
		         		vad.put("slbh", xmxxb.getSlbh());
		         		List<Spjlb> sps=spjlbService.findSpjlball(vad);
		         		if(null!=sps&&sps.size()>0){
		         			Spjlb sp=sps.get(0);
		         			sp.setXxbbh(xxbbh);
		         			spjlbService.update(sp);
		         		}
		         		Map<String, Object> sdj = new HashMap<String, Object>();
		         		sdj.put("xxbbh", yxxb);
		         		List<Sdjd> ss=sdjdService.findSdjd(sdj);
		         		if(null!=ss&&ss.size()>0){
		         			Sdjd sd=ss.get(0);
		         			sd.setXxbbh(xxbbh);
		         			sdjdService.update(sd);
		         		}
		         		List<PaymentItemPending> lis=paymentItemPendingService.findPaymentItemPending(vad);
		         		List<Jktzs> jktzs=jktzsService.findByAll(vad);
		         		List<Cktzs> lck=cktzsService.findByall(vad);
		         		List<Qtfymx> qt=qtfymxService.findall(vad);
		         		List<Jkmx> jkmxs=jkmxService.findall(vad);
		         		if(null!=lis&&lis.size()>0){
		         			for (PaymentItemPending asd : lis) {
		         				paymentItemPendingService.delete(asd.getId());
							}
		         		 }
		         		if(null!=jktzs&&jktzs.size()>0){
		         			for (Jktzs jktbean : jktzs) {
		         				jktzsService.deleteWithFlag(jktbean.getId());
							}
		         			
		         		}
		         		if(null!=lck&&lck.size()>0){
		         			for (Cktzs cktzs : lck) {
		         				cktzsService.deleteWithFlag(cktzs.getId());
							}
		         		}
		         		if(null!=qt&&qt.size()>0){
		         			for (Qtfymx qtfymx : qt) {
		         				qtfymxService.deleteWithFlag(qtfymx.getId());
		         			}
		         		}
		         		if(null!=jkmxs&&jkmxs.size()>0){
		         			for (Jkmx jkmxbean : jkmxs) {
		         				jkmxService.deleteWithFlag(jkmxbean.getId());
							}
		         		}
		          }else{
		         	 //退回
		         	variables.put("sypd", "1");
		          }   
			taskService.complete(taskId,variables);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != xmcxb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到xmcxb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			xmcxbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Xmcxb getXmcxb(){
		return this.xmcxb;
	}

	public void setXmcxb(Xmcxb xmcxb){
		this.xmcxb = xmcxb;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryFhsjStart(){
		return this.queryFhsjStart;
	}

	public void setQueryFhsjStart(Date queryFhsjStart){
		this.queryFhsjStart = queryFhsjStart;
	}

	public Date getQueryFhsjEnd(){
		return this.queryFhsjEnd;
	}

	public void setQueryFhsjEnd(Date queryFhsjEnd){
		this.queryFhsjEnd = queryFhsjEnd;
	}

	public Date getQueryShsjStart(){
		return this.queryShsjStart;
	}

	public void setQueryShsjStart(Date queryShsjStart){
		this.queryShsjStart = queryShsjStart;
	}

	public Date getQueryShsjEnd(){
		return this.queryShsjEnd;
	}

	public void setQueryShsjEnd(Date queryShsjEnd){
		this.queryShsjEnd = queryShsjEnd;
	}


	public Xmxxb getXmxxb() {
		return xmxxb;
	}


	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}


	public String getXmxxbid() {
		return xmxxbid;
	}


	public void setXmxxbid(String xmxxbid) {
		this.xmxxbid = xmxxbid;
	}
   
	
}
