package com.jshx.wwsqys.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.wwsqys.dao.WwsqysDao;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;

@Service("wwsqysService")
public class WwsqysServiceImpl extends BaseServiceImpl implements WwsqysService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("wwsqysDao")
	private WwsqysDao wwsqysDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return wwsqysDao.findByPage(page, paraMap);
	}
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return wwsqysDao.findByPage1(page, paraMap);
	}


	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Wwsqys getById(String id)
	{
		return wwsqysDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Wwsqys wwsqys)
	{
		wwsqysDao.save(wwsqys);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Wwsqys wwsqys)
	{
		wwsqysDao.update(wwsqys);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=wwsqysDao.findWwsqys(paraMap);
		
		wwsqysDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    wwsqysDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Wwsqys> findxxylb(String xxylb) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xxylb", xxylb);
		List<Wwsqys> lws=wwsqysDao.findWwsqys(paraMap);
		return lws;
	}
}
