package com.jshx.tjfx.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.tjfx.entity.Tjfx;
import com.jshx.tjfx.dao.TjfxDao;

@Component("tjfxDao")
public class TjfxDaoImpl extends BaseDaoImpl implements TjfxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageBySqlIdReturnMap("findTjfxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findTjfx(Map<String, Object> paraMap){
		return this.findListByHqlId("findTjfxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Tjfx getById(String id)
	{
		return (Tjfx)this.getObjectById(Tjfx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Tjfx tjfx)
	{
		tjfx.setId(null);
		this.saveOrUpdateObject(tjfx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Tjfx tjfx)
	{
		this.saveOrUpdateObject(tjfx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Tjfx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Tjfx tjfx = (Tjfx)this.getObjectById(Tjfx.class, id);
		tjfx.setDelFlag(1);
		this.saveObject(tjfx);
	}

	@Override
	public List<Map<String,String>> exportDate(Map<String, Object> map) {
		
		return this.findListBySqlIdReturnMap("findTjfxByMap", map);
	}
}
