package com.jshx.tbshxk.service.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;

import com.jshx.core.utils.StringUtil;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.module.admin.web.action.CommonAction;
import net.sf.json.JSONArray;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.tbshxk.dao.TbshxkDao;
import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;

@Service("tbshxkService")
public class TbshxkServiceImpl extends BaseServiceImpl implements TbshxkService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("tbshxkDao")
	private TbshxkDao tbshxkDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return tbshxkDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Tbshxk getById(String id)
	{
		return tbshxkDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param
	 */
	@Transactional
	public void save(Tbshxk tbshxk)
	{
		tbshxkDao.save(tbshxk);
	}

	/**
	 * 修改信息
	 * @param
	 */
	@Transactional
	public void update(Tbshxk tbshxk)
	{
		tbshxkDao.update(tbshxk);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=tbshxkDao.findTbshxk(paraMap);
		
		tbshxkDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    tbshxkDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	@Transactional
	public Tbshxk beforejkfs(String url , Tbshxk tbshxk)
	{
		//发送接口前，存表
		tbshxk.setDelFlag(0);
		//发送地址
		tbshxk.setJkdz(url);
		//发送参数
//		String sendParam = JSONArray.fromObject(map).toString();
//		tbshxk.setFscs(sendParam.substring(1,sendParam.length()-1));

		//上次发送时间
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		tbshxk.setFssj(new Date());

		//重发次数
		tbshxk.setCfcs(0L);

		//发送状态(0：有返回，但是报错  1：没有返回  2：发送成功)
		tbshxk.setFszt("1");

//        if(MapUtils.isNotEmpty(map))
//        {
//            tbshxk.setCzjb(map.get("czjb"));
//            tbshxk.setEcn(map.get("ecn"));
//            tbshxk.setFgwbh(map.get("fgwbh"));
//            tbshxk.setGcxmmc(map.get("gcxmmc"));
//            tbshxk.setGhxkzh(map.get("ghxkzh"));
//            tbshxk.setJddh(map.get("jddh"));
//            tbshxk.setJfpzwj(map.get("jfpzwj"));
//            tbshxk.setJfrq(map.get("jfrq"));
//            tbshxk.setJsdw(map.get("jsdw"));
//            tbshxk.setLxr(map.get("lxr"));
//            tbshxk.setPhone(map.get("phone"));
//            tbshxk.setJfzt(map.get("jfzt"));
//            tbshxk.setPzbh(map.get("pzbh"));
//            tbshxk.setQuxian(map.get("quxian"));
//            tbshxk.setSlbh(map.get("slbh"));
//            tbshxk.setXmdd(map.get("xmdd"));
//            tbshxk.setXxylb(map.get("xxylb"));
//            tbshxk.setZjzmj(map.get("zjzmj"));
//        }


		tbshxkDao.save(tbshxk);
		return tbshxk;
	}

	@Override
	@Transactional
	public void  updateZhuantai(String result,Tbshxk tbshxk)
	{
		//返回结果
		if(StringUtil.isNotEmpty(result))
		{
			String result1 = CommonAction.getValueFromJsonstr(result,"ResultStatus");
			if("1".equals(result1))
			{
				tbshxk.setFszt("2");
			}
			else if("0".equals(result1))
			{
				tbshxk.setFszt("0");
			}
			else
			{
				tbshxk.setFszt("1");
			}
			tbshxk.setCfcs(tbshxk.getCfcs()+1L);
			tbshxk.setDelFlag(0);
//			tbshxk.setCfcs(tbshxk.getResendtime()+1L);
			tbshxk.setFssj(new Date());
			tbshxk.setFhjg(result);
			tbshxkDao.update(tbshxk);
		}
		else
		{
			tbshxk.setFszt("1");
			tbshxk.setCfcs(tbshxk.getCfcs() == null ? 0L :tbshxk.getCfcs()+1L);
			tbshxk.setFssj(new Date());
			tbshxk.setFhjg(result);
			tbshxkDao.update(tbshxk);
		}
	}

}
