package com.jshx.taskAssigneeRecord.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.taskAssigneeRecord.dao.TaskAssigneeRecordDao;
import com.jshx.taskAssigneeRecord.entity.TaskAssigneeRecord;
import com.jshx.taskAssigneeRecord.service.TaskAssigneeRecordService;

@Service("taskAssigneeRecordService")
public class TaskAssigneeRecordServiceImpl extends BaseServiceImpl implements TaskAssigneeRecordService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("taskAssigneeRecordDao")
	private TaskAssigneeRecordDao taskAssigneeRecordDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return taskAssigneeRecordDao.findByPage(page, paraMap);
	}
	
	/**
	 * 不分页查询
	 * @param paraMap
	 * @return
	 */
	public List findTaskAssigneeRecord(Map<String, Object> paraMap)
	{
		return this.taskAssigneeRecordDao.findTaskAssigneeRecord(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public TaskAssigneeRecord getById(String id)
	{
		return taskAssigneeRecordDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(TaskAssigneeRecord taskAssigneeRecord)
	{
		taskAssigneeRecordDao.save(taskAssigneeRecord);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(TaskAssigneeRecord taskAssigneeRecord)
	{
		taskAssigneeRecordDao.update(taskAssigneeRecord);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=taskAssigneeRecordDao.findTaskAssigneeRecord(paraMap);
		
		taskAssigneeRecordDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    taskAssigneeRecordDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public void updateRecord(Map<String, Object> paraMap) {
		this.taskAssigneeRecordDao.executeUpdateByHqlId("updateRecord", paraMap);
		
	}

	
}
