package com.jshx.taskAssigneeRecord.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.taskAssigneeRecord.entity.TaskAssigneeRecord;

public interface TaskAssigneeRecordService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 不分页查询
	 * @param paraMap
	 * @return
	 */
	public List findTaskAssigneeRecord(Map<String, Object> paraMap);
	
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public TaskAssigneeRecord getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(TaskAssigneeRecord model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(TaskAssigneeRecord model);

	/**
	 * 更新操作频率
	 * @param paraMap
	 */
	public void updateRecord(Map<String,Object> paraMap);
	
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
}
