package com.jshx.szys.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

public class SzysAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Szys szys = new Szys();

	/**
	 * 实体类
	 */
	private Xmxxb xmxxb = new Xmxxb();

	/**
	 * 业务类
	 */
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private ZsdwService zsdwService;
	
	/**
	 * 业务类
	 */
	@Autowired
	private SzysService szysService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
     private String comment;
     private String xmbid;
     private String lxr;
     private String phone;
     private String zsfw;
     private String szysid;     
     private String statezt;
     
     
     
	public String getStatezt() {
		return statezt;
	}

	public void setStatezt(String statezt) {
		this.statezt = statezt;
	}

	public String getSzysid() {
		return szysid;
	}

	public void setSzysid(String szysid) {
		this.szysid = szysid;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getXmbid() {
		return xmbid;
	}

	public void setXmbid(String xmbid) {
		this.xmbid = xmbid;
	}

	public String getLxr() {
		return lxr;
	}

	public void setLxr(String lxr) {
		this.lxr = lxr;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getZsfw() {
		return zsfw;
	}

	public void setZsfw(String zsfw) {
		this.zsfw = zsfw;
	}

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryCstimeStart;

	private Date queryCstimeEnd;
   
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
          if(!this.getLoginUser().getIsSuperAdmin()){
        	  String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
  			paraMap.put("bxzd1", dwdm.trim());
          }
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != szys){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != szys.getCsrname()) && (0 < szys.getCsrname().trim().length())){
				paraMap.put("csrname", "%" + szys.getCsrname().trim() + "%");
			}

			if (null != queryCstimeStart){
				paraMap.put("startCstime", queryCstimeStart);
			}

			if (null != queryCstimeEnd){
				paraMap.put("endCstime", queryCstimeEnd);
			}
			if ((null != szys.getXmmc()) && (0 < szys.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + szys.getXmmc().trim() + "%");
			}

			if ((null != szys.getZsdw()) && (0 < szys.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + szys.getZsdw().trim() + "%");
			}
			if ((null != szys.getStarts()) && (0 < szys.getStarts().trim().length())){
				paraMap.put("starts",  szys.getStarts().trim() );
			}

		}
		if(null != xmxxb){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}
		
			if ((null != xmxxb.getJsdd()) && (0 < xmxxb.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + xmxxb.getJsdd().trim() + "%");
			}
			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}
	
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeIdC
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|csrname|cstime|xmmc|zsdw|zsfw|xmxxbzj|";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}
		pagination = szysService.findByPage1(pagination, paraMap);
		pagination.setListOfObject(pagination.getList());
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != szys)&&(null != szys.getId()))
			szys = szysService.getById(szys.getId());
		
		return VIEW;
	}
	/**
	 * 查看详细信息
	 */
	public String view1() throws Exception{
		if((null != xmxxb)&&(null != xmxxb.getId()))
			xmxxb = xmxxbService.getById(xmxxb.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		if((null != szys)&&(null != szys.getId())){
			szys = szysService.getById(szys.getId());
			xmxxb = xmxxbService.getById(szys.getXmxxbzj());
		}
		
	    return EDIT;
	}
	/**
	 * 初审修改信息
	 */
	public String initEditjb() throws Exception{
		view1();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			szys.setDeptId(this.getLoginUserDepartmentId());
			szys.setDelFlag(0);
			szysService.save(szys);
		}else{
			szysService.update(szys);
		}
		
		return RELOAD;
	}
	/**
	 * 复核保存
	 * @return
	 * @throws Exception
	 */
	public String savefh() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
		Szys ss=new Szys();
		Xmxxb xxbfh=new Xmxxb();
		if((null != szys)&&(null != szys.getId())){
			ss = szysService.getById(szys.getId());
			xxbfh = xmxxbService.getById(ss.getXmxxbzj().trim());
			ss.setFhrname(this.getLoginUser().getDisplayName());
			ss.setFhuserid(this.getLoginUserId());
	    	ss.setFhtime(new Date());
			//复核意见
			String a=this.getRequest().getParameter("fhyj");
//			String fhyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
			ss.setFhyj(a);
			xxbfh.setHfsbz(a);
			
			//退回
			if("0".equals(szys.getStarts())){
                ss.setStarts("0");
                xxbfh.setHfsz("2");
			}
			//通过
			if("1".equals(szys.getStarts())){
				ss.setStarts("2");
				xxbfh.setHfsz("4");
			}
			
			xmxxbService.update(xxbfh);
			szysService.update(ss);
		}
		return RELOAD;
	}
	/**
	 *  数字复核保存
	 * @return
	 * @throws Exception
	 */
	public String savefh2() throws Exception{
		
		
		try{
			Szys ss=new Szys();
			Xmxxb xxbfh=new Xmxxb();
			
				ss = szysService.getById(szysid);
				xxbfh = xmxxbService.getById(ss.getXmxxbzj().trim());
				ss.setFhrname(this.getLoginUser().getDisplayName());
				ss.setFhuserid(this.getLoginUserId());
		    	ss.setFhtime(new Date());
				//复核意见
				ss.setFhyj(comment);
				xxbfh.setHfsbz(comment);
				
				//退回
				if("0".equals(statezt)){
	                ss.setStarts("0");
	                xxbfh.setHfsz("2");
				}
				//通过
				if("1".equals(statezt)){
					ss.setStarts("2");
					xxbfh.setHfsz("4");
				}
				
				xmxxbService.update(xxbfh);
				szysService.update(ss);
				
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
		
		
	}
	/**
	 * 数字经办初审
	 * @return
	 * @throws Exception
	 */
	public String savejb() throws Exception{
		
		
	    try{
			Xmxxb xxb=new Xmxxb();
			Szys szys=new Szys();
			if((null != xmbid)){
				xxb = xmxxbService.getById(xmbid);
				//判断是新建,还是退回后修改
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("xmxxbzj", "%" + xmbid.trim() + "%");
				List<Szys> ls=szysService.findSzys(paraMap);
				if(null!=ls&&ls.size()>0){
					szys=ls.get(0);
				}
				//基础信息修改
//				if(null!=xmxxb.getJsdd()&&!"".equals(xmxxb.getJsdd())){
//					xxb.setJsdd(xmxxb.getJsdd());
//				}
//				if(null!=xmxxb.getXkzh()&&!"".equals(xmxxb.getXkzh())){
//					xxb.setXkzh(xmxxb.getXkzh());
//				}
				if(null!=lxr&&!"".equals(lxr)){
					xxb.setLianxiren(lxr);
				}
				if(null!=phone&&!"".equals(phone)){
					xxb.setPhone(phone);
				}
			
				if(null!=zsfw&&!"".equals(zsfw)){
					xxb.setZsfw(zsfw);
					szys.setZsfw(zsfw);
				}
				xxb.setHfsz("3");
				szys.setStarts("1");
				//经办意见
//				String a=this.getRequest().getParameter("csyj");
//				String jbyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
				szys.setCsyj(comment);
				szys.setCstime(new Date());
				szys.setCsrname(this.getLoginUser().getDisplayName());
				szys.setCsuserid(this.getLoginUserId());
				xmxxbService.update(xxb);
				szysService.update(szys);
		
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
		

	}

	
	
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != szys)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到szys中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			szysService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 数字预审经办
	 * @throws Exception
	 */
	public void listjb() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("hfsz", "2");
		if(!this.getLoginUser().getIsSuperAdmin()){
			//查询单位代码
			String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
			paraMap.put("dwdm", dwdm.trim());
		}
		
		if(pagination==null)
			pagination = new Pagination(this.getRequest());
		
		if(null != xmxxb){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length())){
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}
			
			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}
			
			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}
			
			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}
			
			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}
			
			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length())){
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}
			
			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}
			
			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length())){
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}
			if ((null != xmxxb.getJsdd()) && (0 < xmxxb.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + xmxxb.getJsdd().trim() + "%");
			}
			
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|jzmjdx|jzmjdc|jzmj27|jzmj8ys|zjzmjds|csje|hfsbz|xmmc|yjje|jsdd|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	
	
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Szys getSzys(){
		return this.szys;
	}

	public void setSzys(Szys szys){
		this.szys = szys;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryCstimeStart(){
		return this.queryCstimeStart;
	}

	public void setQueryCstimeStart(Date queryCstimeStart){
		this.queryCstimeStart = queryCstimeStart;
	}

	public Date getQueryCstimeEnd(){
		return this.queryCstimeEnd;
	}

	public void setQueryCstimeEnd(Date queryCstimeEnd){
		this.queryCstimeEnd = queryCstimeEnd;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}
    
}
