package com.jshx.szys.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.szys.dao.SzysDao;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;

@Service("szysService")
public class SzysServiceImpl extends BaseServiceImpl implements SzysService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("szysDao")
	private SzysDao szysDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return szysDao.findByPage(page, paraMap);
	}
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return szysDao.findByPage1(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Szys getById(String id)
	{
		return szysDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Szys szys)
	{
		szysDao.save(szys);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Szys szys)
	{
		szysDao.update(szys);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=szysDao.findSzys(paraMap);
		
		szysDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    szysDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Szys> findSzys(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return szysDao.findSzys(paraMap);
	}
}
