package com.jshx.sdjd.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.dao.SdjdDao;

@Component("sdjdDao")
public class SdjdDaoImpl extends BaseDaoImpl implements SdjdDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findSdjdByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findSdjd(Map<String, Object> paraMap){
		return this.findListByHqlId("findSdjdByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Sdjd getById(String id)
	{
		return (Sdjd)this.getObjectById(Sdjd.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Sdjd sdjd)
	{
		sdjd.setId(null);
		this.saveOrUpdateObject(sdjd);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Sdjd sdjd)
	{
		this.saveOrUpdateObject(sdjd);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Sdjd.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Sdjd sdjd = (Sdjd)this.getObjectById(Sdjd.class, id);
		sdjd.setDelFlag(1);
		this.saveObject(sdjd);
	}
}
