package com.jshx.schedule.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.schedule.entity.Schedule1;
import com.jshx.schedule.dao.Schedule1Dao;

@Component("schedule1Dao")
public class Schedule1DaoImpl extends BaseDaoImpl implements Schedule1Dao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findSchedule1ByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findSchedule1(Map<String, Object> paraMap){
		return this.findListByHqlId("findSchedule1ByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Schedule1 getById(String id)
	{
		return (Schedule1)this.getObjectById(Schedule1.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Schedule1 schedule1)
	{
		schedule1.setId(null);
		this.saveOrUpdateObject(schedule1);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Schedule1 schedule1)
	{
		this.saveOrUpdateObject(schedule1);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Schedule1.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Schedule1 schedule1 = (Schedule1)this.getObjectById(Schedule1.class, id);
		schedule1.setDelFlag(1);
		this.saveObject(schedule1);
	}
}
