/**
 * 
 */
package com.jshx.rutaskinfo.web;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.service.impl.UserServiceImpl;
import com.jshx.rutaskinfo.entity.RuTaskInfo;

/**
 * @author chensy
 * @version 2016年9月27日 下午1:41:28
 */
@Service("ruTaskInfoUtil")
public class RuTaskInfoUtil{
	
	@Autowired
	private UserService userService;
    @Autowired
    protected RepositoryService repositoryService;
	private String className = "";
	private String url = "";
	private String username = "";
	private String password = "";
	protected static Logger logger = LoggerFactory.getLogger(BaseAction.class);
	Connection conn = null;
	
	/**
	 * 
	 */
	public RuTaskInfoUtil() {

	}
	
	public void loadProperty(){
		try {
			Properties oProperties = new Properties();
			ClassLoader oClassLoader = Thread.currentThread().getContextClassLoader();

			InputStream is = oClassLoader.getResourceAsStream("jdbc.properties");

			if (is != null) {
				oProperties.load(is);
				is.close();
			} else {
				logger.error("SysPropertiesUtil can not load property files!");
			}
			
			className = oProperties.getProperty("db.driverClassName");
			url = oProperties.getProperty("db.url");
			username = oProperties.getProperty("db.username");
			password = oProperties.getProperty("db.password");

		} catch (Exception e) {
			logger.error(e.toString());
			e.printStackTrace();
		}
	}
	
	public Connection getConnection() {
		try {
			if (conn == null || conn.isClosed()) {
				// 加载驱动
				Class.forName(className);
				// 建立数据库连接
				conn = DriverManager.getConnection(url, username, password);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return conn;
	}
	
	public int getTotalCount() throws SQLException {
		// TODO Auto-generated method stub
		int total = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {

			// 创建查询sql语句
			StringBuffer selectSql = new StringBuffer();
			selectSql.append("SELECT count(*) FROM act_ru_task");
			
			// 创建PreparedStatment接口
			pstmt = conn.prepareStatement(selectSql.toString());

			// 创建ResultSet结果集对象接收返回结果集
			rs = pstmt.executeQuery();

			if (rs.next()) {
				total = rs.getInt(1);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			// 关闭资源
			if (rs != null) {
				rs.close();
			}

			if (pstmt != null) {
				pstmt.close();
			}
		}

		return total;
	}

	public List<RuTaskInfo> getPageList(final Pagination pagination, Map<String, Object> paraMap) throws SQLException {
		// TODO Auto-generated method stub
		List<RuTaskInfo> list = new ArrayList<RuTaskInfo>();

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		pagination.setTotalCount(getTotalCount());
		
		Map<String, RuTaskInfo> resultMap = new HashMap<>();

		try {
			// 打开连接
			conn = getConnection();
			// 创建查询sql语句
			StringBuffer selectSql = new StringBuffer();

			/*
			 * Oracle查询语句
			 * 由于三张表不对应（hi_procinst表由于任务回退而产生冗余数据），因此分页采用查询全部数据，
			 * 之后筛选数据，最后手工分页的方式进行
			 */
			selectSql.append("SELECT t.PROC_DEF_ID_,t.NAME_,"
					+ "t.CREATE_TIME_,t.ID_,t.PROC_INST_ID_,t.ASSIGNEE_,t.DUE_DATE_,p.START_USER_ID_,"
					+ "p.START_TIME_,p.BUSINESS_KEY_,ht.CLAIM_TIME_ FROM act_ru_task t,act_hi_procinst p,"
					+ "act_hi_taskinst ht WHERE p.PROC_INST_ID_ = t.PROC_INST_ID_ AND ht.PROC_INST_ID_ "
					+ "= t.PROC_INST_ID_ AND ht.TASK_DEF_KEY_ = t.TASK_DEF_KEY_ ");
			
			String taskState = null;
			String businessKey = null;
			String queryStartTimeStart = null;
			String queryStartTimeEnd = null;
			String queryDueDateStart = null;
			String queryDueDateEnd = null;
			if(paraMap.containsKey("taskState")){
				taskState = paraMap.get("taskState").toString();
				if(taskState.equals("01")){
					taskState = "已签收，正在处理";
				}
				if(taskState.equals("02")){
					taskState = "未签收";
				}
				if(taskState.equals("03")){
					taskState = "已超时";
				}
			}
			
			if(paraMap.containsKey("businessKey"))
				businessKey = paraMap.get("businessKey").toString();
			if(paraMap.containsKey("queryStartTimeStart"))
				queryStartTimeStart = paraMap.get("queryStartTimeStart").toString();
			if(paraMap.containsKey("queryStartTimeEnd"))
				queryStartTimeEnd = paraMap.get("queryStartTimeEnd").toString();
			if(paraMap.containsKey("queryDueDateStart"))
				queryDueDateStart = paraMap.get("queryDueDateStart").toString();
			if(paraMap.containsKey("queryDueDateEnd"))
				queryDueDateEnd = paraMap.get("queryDueDateEnd").toString();
			

			if (null != businessKey && !businessKey.isEmpty()) {
				selectSql.append(" and p.BUSINESS_KEY_ = '" + businessKey + "'");
			}
			if(null != queryStartTimeStart && !queryStartTimeStart.isEmpty()){
				selectSql.append(" and t.CREATE_TIME_ > to_date('" + queryStartTimeStart + "','yyyy-MM-dd hh24:mi:ss')");
			}
			if(null != queryStartTimeEnd && !queryStartTimeEnd.isEmpty()){
				selectSql.append(" and t.CREATE_TIME_ < to_date('" + queryStartTimeEnd + "','yyyy-MM-dd hh24:mi:ss')");
			}
			if(null != queryDueDateStart && !queryDueDateStart.isEmpty()){
				selectSql.append(" and t.DUE_DATE_ > to_date('" + queryDueDateStart + "','yyyy-MM-dd hh24:mi:ss')");
			}
			if(null != queryDueDateEnd && !queryDueDateEnd.isEmpty()){
				selectSql.append(" and t.DUE_DATE_ < to_date('" + queryDueDateEnd + "','yyyy-MM-dd hh24:mi:ss')");
			}

			// 创建PreparedStatment接口
			pstmt = conn.prepareStatement(selectSql.toString());
			// 创建ResultSet结果集对象接收返回结果集
			rs = pstmt.executeQuery();
			while (rs.next()) {
				RuTaskInfo rInfo = new RuTaskInfo();
//				Map<String, Object> paraMap2 = new HashMap<String, Object>();
//				paraMap2.put("loginId", "%" + rs.getString("START_USER_ID_").trim() + "%");
				User user=userService.findUserByLoginId(rs.getString("START_USER_ID_").trim());
				rInfo.setId("0");
				rInfo.setClaimTime(rs.getTimestamp("CLAIM_TIME_"));
				rInfo.setDueDate(rs.getTimestamp("DUE_DATE_"));
				//流程名称
				rInfo.setProcDefId(rs.getString("PROC_DEF_ID_").split(":")[0]);
				 ProcessDefinitionQuery processDefinitionQuery = repositoryService.createProcessDefinitionQuery().orderByDeploymentId().desc();
				processDefinitionQuery = processDefinitionQuery.processDefinitionKeyLike("%" + (rs.getString("PROC_DEF_ID_").split(":")[0] + "%"));
				List<ProcessDefinition> processDefList=processDefinitionQuery.list();
				
				if(processDefList.size()>0){
				String a=processDefList.get(0).getName();
				rInfo.setProcDefId(a);
				}
				
				rInfo.setStartTime(rs.getTimestamp("START_TIME_"));
				rInfo.setStartUserId(rs.getString("START_USER_ID_"));
				if(null!=user){
				rInfo.setStartUserId(user.getDisplayName());
				}else{
					rInfo.setStartUserId("");
				}
				rInfo.setTaskDefKey(rs.getString("NAME_"));
				rInfo.setTaskId(rs.getString("ID_"));
				rInfo.setProcInstId(rs.getString("PROC_INST_ID_"));
				rInfo.setBusinessKey(rs.getString("BUSINESS_KEY_"));
				
				String assignee = rs.getString("ASSIGNEE_");
				if(assignee == null || assignee.isEmpty()){
					rInfo.setTaskState("未签收");
					rInfo.setAssignee(" ");
				}else{
					User uu=userService.findUserByLoginId(rs.getString("ASSIGNEE_"));
					if(null!=uu){
						rInfo.setAssignee(uu.getDisplayName());
					}else{
						rInfo.setAssignee(" ");
					}
					rInfo.setTaskState("已签收，正在处理");
				}
				
				Date currentDate = new Date();
				if(null != rInfo.getDueDate() && currentDate.getTime() > rInfo.getDueDate().getTime()){
					rInfo.setTaskState("已超时");
				}	
				
				String key = rInfo.getProcInstId()+rInfo.getTaskDefKey();
				if(null != resultMap && resultMap.containsKey(key)){
					if(resultMap.get(key).getStartTime().getTime() > rInfo.getStartTime().getTime())
						continue;
				}

				if(null != taskState && !taskState.isEmpty()){
					if (taskState.equals(rInfo.getTaskState())) {
						resultMap.put(key, rInfo);
					} else {
						continue;
					}				
				}else{
					resultMap.put(key, rInfo);
				}
			}
			Iterator<Map.Entry<String, RuTaskInfo>> it =resultMap.entrySet().iterator();
			int count = 0;
			while(it.hasNext()){
				if(count >= (pagination.getPageNumber()-1) * pagination.getPageSize() &&
						count < pagination.getPageNumber()*pagination.getPageSize()){
					list.add(it.next().getValue());
				}else {
					it.next();
				}
				count++;
				if(count >= pagination.getPageNumber()*pagination.getPageSize()){
					break;
				}
			}
			pagination.setList(list);
			pagination.setTotalCount(resultMap.size());
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			// 关闭资源
			if (rs != null) {
				rs.close();
			}

			if (pstmt != null) {
				pstmt.close();
			}

			if (conn != null) {
				conn.close();
			}
		}

		return list;
	}
}
