package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmSfxxDao;
import com.jshx.rfxm.dao.RfxmSfxxHistoryDao;
import com.jshx.rfxm.entity.RfxmSfxx;
import com.jshx.rfxm.entity.RfxmSfxxHistory;
import com.jshx.rfxm.service.RfxmSfxxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmSfxxService")
public class RfxmSfxxServiceImpl extends BaseServiceImpl implements RfxmSfxxService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("rfxmSfxxDao")
	private RfxmSfxxDao rfxmSfxxDao;

	@Autowired()
	@Qualifier("rfxmSfxxHistoryDao")
	private RfxmSfxxHistoryDao rfxmSfxxHistoryDao;

	@Transactional
	public List<RfxmSfxx> findRfxmSfxx(Map<String, Object> paraMap) {
		return rfxmSfxxDao.findRfxmSfxx(paraMap);
	}

	@Override
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return rfxmSfxxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmSfxx getById(String id)
	{
		return rfxmSfxxDao.getById(id);
	}

	@Override
	public RfxmSfxx getByYbjksbh(String ybjksbh)
	{
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		RfxmSfxx rfxmSfxx = (RfxmSfxx)rfxmSfxxDao.findObjectByFieldsMap(RfxmSfxx.class,paramMap);
		return rfxmSfxx;
	}

	@Override
	public RfxmSfxx getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		RfxmSfxx rfxmSfxx = (RfxmSfxx)rfxmSfxxDao.findObjectByFieldsMap(RfxmSfxx.class,paramMap);
		return rfxmSfxx;
	}

	/**
	 * 保存信息
	 * @param rfxmSfxx 信息
	 */
	@Transactional
	public void save(RfxmSfxx rfxmSfxx)
	{
		rfxmSfxxDao.save(rfxmSfxx);
	}

	/**
	 * 修改信息
	 * @param rfxmSfxx 信息
	 */
	@Transactional
	public void update(RfxmSfxx rfxmSfxx)
	{
		rfxmSfxxDao.update(rfxmSfxx);
	}

	/**
	 * 修改收费信息并插入到历史表中
	 * @param sfxx
	 * @param sfxxHistory
	 */
	@Transactional
	@Override
	public void updateAndSaveHistory(RfxmSfxx sfxx, RfxmSfxxHistory sfxxHistory) {
		rfxmSfxxHistoryDao.save(sfxxHistory);
		rfxmSfxxDao.update(sfxx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmSfxxDao.findRfxmSfxx(paraMap);

		rfxmSfxxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmSfxxDao.deleteWithFlag(id);
			}
		}
	}

}
