package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.dao.ZzhglDao;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.rfxm.dao.*;
import com.jshx.rfxm.entity.*;
import com.jshx.rfxm.service.RfxmJktzsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmjktzsService")
public class RfxmJktzsServiceImpl extends BaseServiceImpl implements RfxmJktzsService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("rfxmjktzsDao")
	private RfxmJktzsDao rfxmJktzsDao;
	@Autowired()
	@Qualifier("rfxmJktzsHistoryDao")
	private RfxmJktzsHistoryDao rfxmJktzsHistoryDao;
	@Autowired()
	@Qualifier("zzhglDao")
	private ZzhglDao zzhglDao;
	@Autowired()
	@Qualifier("rfxmDao")
	private RfxmDao rfxmDao;
	@Autowired()
	@Qualifier("rfxmSfxxDao")
	private RfxmSfxxDao rfxmSfxxDao;
	@Autowired()
	@Qualifier("rfxmSfxxHistoryDao")
	private RfxmSfxxHistoryDao rfxmSfxxHistoryDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmJktzsDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzs getById(String id)
	{
		return rfxmJktzsDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxmJktzs 信息
	 */
	@Transactional
	public void save(RfxmJktzs rfxmJktzs)
	{
		rfxmJktzsDao.save(rfxmJktzs);
	}

	/**
	 * 接口1保存信息
	 * @param rfxmJktzs
	 * @param rfxmSfxxListzl
	 * @param zzh
	 */
	@Transactional
	@Override
	public void saveJK1(RfxmJktzs rfxmJktzs,List<RfxmSfxx> rfxmSfxxListzl,Zzh zzh) {
		//保存项目表
//		rfxmDao.save(rfxm);
		// 保存缴款通知书表
		rfxmJktzsDao.save(rfxmJktzs);
		// 保存RfxmSfxx表
		for(int i=0;i<rfxmSfxxListzl.size();i++){
			RfxmSfxx rfxmSfxxi = rfxmSfxxListzl.get(i);
			rfxmSfxxDao.save(rfxmSfxxi);
		}
		//更新子账户表
		zzhglDao.update(zzh);
	}

	/**
	 * 接口2保存信息
	 * @param zzh
	 * @param rfxmJktzs
	 */
	@Transactional
	@Override
	public void saveJK2(Zzh zzh, RfxmJktzs rfxmJktzs) {
		//更新子账户
		zzhglDao.update(zzh);
		// 更新缴款通知书表
		if(null != rfxmJktzs.getAccountDetail()){
			rfxmJktzsDao.update(rfxmJktzs);
		}
	}

	@Transactional
	@Override
	public void saveByTrans(RfxmJktzs jktzs, List<RfxmSfxx> rfxmSfxx, Rfxm rfxm, Zzh zzhgl) {

		zzhglDao.update(zzhgl);
		// 更新对应的rfxm
		rfxmDao.update(rfxm);
		// 更新对应的RfxmSfxx
		for (RfxmSfxx sfxx : rfxmSfxx) {
			rfxmSfxxDao.update(sfxx);
		}
		rfxmJktzsDao.saveOrUpdateObject(jktzs);
	}

	/**
	 * 作废缴款通知书
	 * @param jktzsHistory
	 * @param sfxxHistories
	 * @return
	 */

	@Transactional
	@Override
	public int invalidNotice(RfxmJktzs jktzs, RfxmJktzsHistory jktzsHistory, List<RfxmSfxxHistory> sfxxHistories, Zzh accountDetail) {
		try {

			// 1 删除jktzs中的记录 ×

			// 2 添加到历史表
			rfxmJktzsHistoryDao.save(jktzsHistory);
			//循环插入及删除该缴款通知书关联的收费信息
			for (RfxmSfxxHistory sfxxHistory : sfxxHistories) {
				rfxmSfxxDao.deleteWithFlag(sfxxHistory.getId());
				rfxmSfxxHistoryDao.save(sfxxHistory);
			}
			Rfxm rfxm = rfxmDao.getById(jktzsHistory.getRfxmid());
			//判断属于哪个缴费环节
			int i = jktzsHistory.getStatusCnjfhj();
			if (i == 0) {
				rfxm.setStatusConstract(0);
			}
			if (i == 1) {
				rfxm.setStatusComplete(0);
			}
			if (i == 2){
				Map paraMap = new HashMap();
				paraMap.put("rfxmid", jktzsHistory.getRfxmid());
				paraMap.put("typeCnjfhj", jktzsHistory.getStatusCnjfhj());
				List sfxxs = rfxmSfxxDao.findRfxmSfxx(paraMap);
				//如果有多条则不修改状态
				if (sfxxs.size()<=1) {
					rfxm.setStatusWithinTheDay(0);
				}
			}
			rfxmDao.update(rfxm);
            //修改子账户的状态
            zzhglDao.update(accountDetail);
            // 1. 作废状态更改 by 2019-8-2
//			rfxmJktzsDao.deleteWithFlag(jktzsHistory.getId());
            jktzs.setInvalidStatus(1);
            rfxmJktzsDao.update(jktzs);
			return 1;
		}catch (Exception e) {
			e.printStackTrace();
            throw new RuntimeException();
		}
	}

	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	@Transactional
	public void update(RfxmJktzs rfxmJktzs)
	{
		rfxmJktzsDao.update(rfxmJktzs);
	}


	@Transactional
	@Override
	public void updateNotSave(RfxmJktzs rfxmJktzs)
	{
		rfxmJktzsDao.update(rfxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmJktzsDao.findRfxmJktzs(paraMap);

		rfxmJktzsDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmJktzsDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<RfxmJktzs> findRfxmJktzs(Map<String, Object> paraMap) {

		return rfxmJktzsDao.findRfxmJktzs(paraMap);

	}

	@Override
	public RfxmJktzs getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		RfxmJktzs rfxmJktzs = (RfxmJktzs)rfxmJktzsDao.findObjectByFieldsMap(RfxmJktzs.class,paramMap);
		return rfxmJktzs;
	}

	@Override
	public RfxmJktzs getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		RfxmJktzs rfxmJktzs = (RfxmJktzs)rfxmJktzsDao.findObjectByFieldsMap(RfxmJktzs.class,paramMap);
		return rfxmJktzs;
	}

	/**
	 * 根据缴款通知编号查询信息
	 * @param jktzsbh
	 */
	public RfxmJktzs getByJktzsbh(String jktzsbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jktzsbh",jktzsbh);
		RfxmJktzs zzhqfdz = (RfxmJktzs)rfxmJktzsDao.findObjectByFieldsMap(RfxmJktzs.class,paramMap);
		return zzhqfdz;
	}

	/**
	 * 根据清分缴款联系id查询信息
	 * @param qfjklxid
	 */
	public RfxmJktzs getByQfjklxid(String qfjklxid){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("qfjklxid",qfjklxid);
		RfxmJktzs rfxmJktzs = (RfxmJktzs)rfxmJktzsDao.findObjectByFieldsMap(RfxmJktzs.class,paramMap);
		return rfxmJktzs;
	}
}
