package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmqfhtkDao;
import com.jshx.rfxm.entity.Rfxmqfhtk;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: Danfoen
 * @Description:
 * @Date: Created in 14:17 2019/5/23
 * @Modifird by:
 */
@Component("rfxmqfhtkDao")
public class RfxmqfhtkDaoImpl extends BaseDaoImpl implements RfxmqfhtkDao {

    /**
     * 分页查询
     * @param page 分页信息
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
    {
        return this.findPageByHqlId("findRfxmqfhtkByMap", paraMap, page);
    }


    /**
     * 查询所有记录
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    @Override
    public List findRfxmqfhtk(Map<String, Object> paraMap) {
        return this.findListByHqlId("findRfxmqfhtkByMap", paraMap);
    }

    /**
     * 根据主键ID查询信息
     * @param id 主键ID
     * @return 主键ID对应的信息
     */
    @Override
    public Rfxmqfhtk getById(String id) {
        return (Rfxmqfhtk) this.getObjectById(Rfxmqfhtk.class, id);
    }

    /**
     * 保存信息
     * @param rfxmqfhtk 信息
     */
    @Override
    public void save(Rfxmqfhtk rfxmqfhtk) {
        rfxmqfhtk.setId(null);
        this.saveOrUpdateObject(rfxmqfhtk);
    }

    /**
     * 修改信息
     * @param rfxmqfhtk 信息
     */
    @Override
    public void update(Rfxmqfhtk rfxmqfhtk) {
        this.saveOrUpdateObject(rfxmqfhtk);
    }

    /**
     * 物理删除信息
     * @param id 主键ID
     */
    @Override
    public void delete(String id) {
        this.removeObjectById(Rfxmqfhtk.class, id);
    }

    /**
     * 逻辑删除信息
     * @param id 主键ID
     */
    @Override
    public void deleteWithFlag(String id) {
        Rfxmqfhtk rfxmqfhtk = (Rfxmqfhtk)this.getObjectById(Rfxmqfhtk.class, id);
        rfxmqfhtk.setDelFlag(1);
        this.saveObject(rfxmqfhtk);
    }
}
