package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmSfxxDao;
import com.jshx.rfxm.dao.RfxmSfxxHistoryDao;
import com.jshx.rfxm.entity.RfxmSfxx;
import com.jshx.rfxm.entity.RfxmSfxxHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("rfxmSfxxHistoryDao")
public class RfxmSfxxHistoryDaoImpl extends BaseDaoImpl implements RfxmSfxxHistoryDao
{

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxmSfxxHistory(Map<String, Object> paraMap){
		return this.findListByHqlId("findRfxmSfxxByMap", paraMap);
	}

	/**
	 * 分页查询
	 * @param page
	 * @param paraMap
	 * @return
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRfxmSfxxByMap", paraMap, page);
	}
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmSfxxHistory getById(String id)
	{
		return (RfxmSfxxHistory) this.getObjectById(RfxmSfxxHistory.class, id);
	}

	/**
	 * 保存信息
	 * @param rfxmSfxx 信息
	 */
	public void save(RfxmSfxxHistory rfxmSfxx)
	{
		rfxmSfxx.setId(null);
		this.saveOrUpdateObject(rfxmSfxx);
	}

	/**
	 * 修改信息
	 * @param rfxmSfxx 信息
	 */
	public void update(RfxmSfxxHistory rfxmSfxx)
	{
		this.saveOrUpdateObject(rfxmSfxx);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(RfxmSfxxHistory.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RfxmSfxxHistory rfxmSfxx = (RfxmSfxxHistory)this.getObjectById(RfxmSfxxHistory.class, id);
		rfxmSfxx.setDelFlag(1);
		this.saveObject(rfxmSfxx);
	}
}
