package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmJktzsHistoryDao;
import com.jshx.rfxm.entity.RfxmJktzs;
import com.jshx.rfxm.entity.RfxmJktzsHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("rfxmJktzsHistoryDao")
public class RfxmJktzsHistoryDaoImpl extends BaseDaoImpl implements RfxmJktzsHistoryDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRfxmJktzsByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxmJktzsHistory(Map<String, Object> paraMap){
		return this.findListByHqlId("findRfxmJktzsHistoryByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzsHistory getById(String id)
	{
		return (RfxmJktzsHistory)this.getObjectById(RfxmJktzsHistory.class, id);
	}

	/**
	 * 保存信息
	 * @param rfxmJktzs 信息
	 */
	public void save(RfxmJktzsHistory rfxmJktzsHistory)
	{
		rfxmJktzsHistory.setId(null);
		this.saveOrUpdateObject(rfxmJktzsHistory);
	}

	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	public void update(RfxmJktzsHistory rfxmJktzsHistory)
	{
		this.saveOrUpdateObject(rfxmJktzsHistory);
	}
	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	@Override
	public void updateNotSave(RfxmJktzsHistory rfxmJktzsHistory)
	{
		this.update(rfxmJktzsHistory);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(RfxmJktzsHistory.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RfxmJktzsHistory rfxmJktzsHistory = (RfxmJktzsHistory)this.getObjectById(RfxmJktzsHistory.class, id);
		rfxmJktzsHistory.setDelFlag(1);
		this.saveObject(rfxmJktzsHistory);
	}
}
