package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmJktzsDao;
import com.jshx.rfxm.entity.RfxmJktzs;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("rfxmjktzsDao")
public class RfxmJktzsDaoImpl extends BaseDaoImpl implements RfxmJktzsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRfxmJktzsByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxmJktzs(Map<String, Object> paraMap){
		return this.findListByHqlId("findRfxmJktzsByMap", paraMap);
	}

	public List findYzsMaterialCol(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzsMaterialColByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzs getById(String id)
	{
		return (RfxmJktzs)this.getObjectById(RfxmJktzs.class, id);
	}

	/**
	 * 保存信息
	 * @param rfxmJktzs 信息
	 */
	public void save(RfxmJktzs rfxmJktzs)
	{
		rfxmJktzs.setId(null);
		this.saveOrUpdateObject(rfxmJktzs);
	}

	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	public void update(RfxmJktzs rfxmJktzs)
	{
		this.saveOrUpdateObject(rfxmJktzs);
	}
	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	@Override
	public void updateNotSave(RfxmJktzs rfxmJktzs)
	{
		this.update(rfxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(RfxmJktzs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RfxmJktzs rfxmJktzs = (RfxmJktzs)this.getObjectById(RfxmJktzs.class, id);
		rfxmJktzs.setDelFlag(1);
		this.saveObject(rfxmJktzs);
	}
}
