package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmEntityHistoryDao;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmEntityHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("rfxmEntityHistoryDao")
public class RfxmEntityHistoryDaoImpl extends BaseDaoImpl implements RfxmEntityHistoryDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRfxmHistoryEntityByMap", paraMap, page);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findRfxmHistoryEntityByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxm(Map<String, Object> paraMap){
		return this.findListByHqlId("findRfxmHistoryEntityByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmEntityHistory getById(String id)
	{
		return (RfxmEntityHistory) this.getObjectById(Rfxm.class, id);
	}

	/**
	 * 保存信息
	 * @param rfxm 信息
	 */
	public void save(RfxmEntityHistory rfxm)
	{
		rfxm.setId(null);
		this.saveOrUpdateObject(rfxm);
	}

	/**
	 * 修改信息
	 * @param rfxm 信息
	 */
	public void update(RfxmEntityHistory rfxm)
	{
		this.saveOrUpdateObject(rfxm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Rfxm.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RfxmEntityHistory rfxm = (RfxmEntityHistory)this.getObjectById(RfxmEntityHistory.class, id);
		rfxm.setDelFlag(1);
		this.saveObject(rfxm);
	}
}
