package com.jshx.rfxm.dao;

import com.jshx.core.base.dao.BaseDao;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.entity.RfxmJktzs;

import java.util.List;
import java.util.Map;


public interface RfxmJktzsDao extends BaseDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxmJktzs(Map<String, Object> paraMap);

	public List findYzsMaterialCol(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzs getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(RfxmJktzs model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(RfxmJktzs model);

	public void updateNotSave(RfxmJktzs model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id);
}
