package com.jshx.rfdz.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfdz.dao.RfdzDao;
import com.jshx.rfdz.entity.Rfdz;
import com.jshx.rfdz.service.RfdzService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("paymentItemRfService")
public class RfdzServiceImpl extends BaseServiceImpl implements RfdzService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentItemRfDao")
	private RfdzDao rfdzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfdzDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfdz getById(String id)
	{
		return rfdzDao.getById(id);
	}
	
	/**根据受理编号查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public Rfdz getByOrderId(String orderId) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("slbh", orderId);
		Rfdz paymentItemRf = (Rfdz) rfdzDao.findObjectByFieldsMap(Rfdz.class, paraMap);
		return paymentItemRf;
	}
	
	/**根据项目表id查询代缴款项目
	 * @return
	 */
	public Rfdz getByXmbId(String xmbzj)	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		Rfdz paymentItemRf = (Rfdz) rfdzDao.findObjectByFieldsMap(Rfdz.class, paraMap);
		return paymentItemRf;
	}
	
	/**根据凭证查询代缴款项目
	 * @return
	 */
	public Rfdz getByZslxdbh(String zslxdbh)	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("zslxdbh", zslxdbh);
		Rfdz paymentItemRf = (Rfdz) rfdzDao.findObjectByFieldsMap(Rfdz.class, paraMap);
		return paymentItemRf;
	}

	/**
	 * 保存信息
	 */
	@Transactional
	public void save(Rfdz paymentItemRf)
	{
		rfdzDao.save(paymentItemRf);
	}

	/**
	 * 修改信息
	 */
	@Transactional
	public void update(Rfdz paymentItemRf)
	{
		rfdzDao.update(paymentItemRf);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= rfdzDao.findPaymentItemRf(paraMap);
		
		rfdzDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    rfdzDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Rfdz> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return rfdzDao.findPaymentItemRf(paraMap);
	}
}
