package com.jshx.returnItem.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.common.utils.Constant;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.returnItem.dao.ReturnItemDao;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;

@Service("returnItemService")
public class ReturnItemServiceImpl extends BaseServiceImpl implements ReturnItemService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("returnItemDao")
	private ReturnItemDao returnItemDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return returnItemDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ReturnItem getById(String id)
	{
		return returnItemDao.getById(id);
	}
	
	public ReturnItem getByXmbzj(String xmbzj)
	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		paraMap.put("delFlag",0);
		paraMap.put("isCheck", true);
		List<ReturnItem> returnItemList = returnItemDao.findListByHqlId("findReturnItemByMap", paraMap);
		return returnItemList.get(0);
	}
	
	public ReturnItem getByXmbzjWithGQEnd(String xmbzj)
	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		paraMap.put("delFlag",0);
		paraMap.put("returnStatus", "2");
		List<ReturnItem> returnItemList = returnItemDao.findListByHqlId("findReturnItemByMap", paraMap);
		if(null!=returnItemList&&returnItemList.size()>0){
			return returnItemList.get(0);
		}
		return null;
	}
	
	public ReturnItem getByXmbzjWithZFEnd(String xmbzj)
	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		paraMap.put("delFlag",0);
		paraMap.put("returnStatus", "3");
		List<ReturnItem> returnItemList = returnItemDao.findListByHqlId("findReturnItemByMap", paraMap);
		if(null!=returnItemList&&returnItemList.size()>0){
			return returnItemList.get(0);
		}
		return null;
		
	}
	
	public ReturnItem getByXmbzjAndProcessInsId(String xmbzj,String processInsId)
	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		paraMap.put("processInsId",processInsId);
		ReturnItem returnItem = (ReturnItem)returnItemDao.findObjectByFieldsMap(ReturnItem.class, paraMap);
		return returnItem;
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(ReturnItem returnItem)
	{
		returnItemDao.save(returnItem);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(ReturnItem returnItem)
	{
		returnItemDao.update(returnItem);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String id)
	{
		returnItemDao.removeObjectById(ReturnItem.class, id);
	}
	
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=returnItemDao.findReturnItem(paraMap);
		
		returnItemDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    returnItemDao.deleteWithFlag(id);
			}
		}
	}
}
