package com.jshx.returnItem.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.xmxxb.entity.Xmxxb;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="RETURN_ITEM")
public class ReturnItem extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 项目表主键
	 */
	private String xmbzj;
	
	private Xmxxb xmxxb;

	/**
	 * 退件审核状态
	 */
	private String returnStatus;

	/**
	 * 流程实例ID
	 */
	private String processInsId;

	/**
	 * 联系电话
	 */
	private String lxdh;

	/**
	 * 退件原因
	 */
	private String tjyy;

	/**
	 * 建设单位
	 */
	private String jsdw;

	/**
	 * 项目名称
	 */
	private String xmmc;

	/**
	 * 项目地点
	 */
	private String xmdd;

	/**
	 * 窗口编号
	 */
	private String ckbh;

	/**
	 * 受理编号
	 */
	private String slbh;

	/**
	 * 信息一览表编号
	 */
	private String xxylb;

	/**
	 * 总建筑面积
	 */
	private String zjzmj;
	
	/**
	 * 办理类别
	 */
	private String bllb;

	/**
	 * 缴费单位联系人
	 */
	private String lxr;
	
	/**
	 * 单位代码
	 */
	private String dwdm;
	
	/**
	 * 打印审核退件单
	 */
	private String printFlag;
	
	/**
	 * 退件单编号
	 */
	private String tjdbh;

	
	public ReturnItem(){
	}
	
	public ReturnItem(String id, String returnStatus, String processInsId, String lxdh, String jsdw, String xmmc, String xmdd, String ckbh, String slbh, String xxylb, String zjzmj, String lxr){
this.id = id;

this.returnStatus = returnStatus;

this.processInsId = processInsId;

this.lxdh = lxdh;

this.jsdw = jsdw;

this.xmmc = xmmc;

this.xmdd = xmdd;

this.ckbh = ckbh;

this.slbh = slbh;

this.xxylb = xxylb;

this.zjzmj = zjzmj;

this.lxr = lxr;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="XMBZJ")
	public String getXmbzj()
	{
		return this.xmbzj;
	}

	public void setXmbzj(String xmbzj)
	{
		this.xmbzj = xmbzj;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=Xmxxb.class)
	@JoinColumn(name = "XMBZJ",updatable=false,insertable=false)
	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	@Column(name="RETURN_STATUS")
	public String getReturnStatus()
	{
		return this.returnStatus;
	}

	public void setReturnStatus(String returnStatus)
	{
		this.returnStatus = returnStatus;
	}

	@Column(name="PROCESS_INS_ID")
	public String getProcessInsId()
	{
		return this.processInsId;
	}

	public void setProcessInsId(String processInsId)
	{
		this.processInsId = processInsId;
	}

	@Column(name="LXDH")
	public String getLxdh()
	{
		return this.lxdh;
	}

	public void setLxdh(String lxdh)
	{
		this.lxdh = lxdh;
	}

	@Column(name="TJYY")
	public String getTjyy()
	{
		return this.tjyy;
	}

	public void setTjyy(String tjyy)
	{
		this.tjyy = tjyy;
	}

	@Column(name="JSDW")
	public String getJsdw()
	{
		return this.jsdw;
	}

	public void setJsdw(String jsdw)
	{
		this.jsdw = jsdw;
	}

	@Column(name="XMMC")
	public String getXmmc()
	{
		return this.xmmc;
	}

	public void setXmmc(String xmmc)
	{
		this.xmmc = xmmc;
	}

	@Column(name="XMDD")
	public String getXmdd()
	{
		return this.xmdd;
	}

	public void setXmdd(String xmdd)
	{
		this.xmdd = xmdd;
	}

	@Column(name="CKBH")
	public String getCkbh()
	{
		return this.ckbh;
	}

	public void setCkbh(String ckbh)
	{
		this.ckbh = ckbh;
	}

	@Column(name="SLBH")
	public String getSlbh()
	{
		return this.slbh;
	}

	public void setSlbh(String slbh)
	{
		this.slbh = slbh;
	}

	@Column(name="XXYLB")
	public String getXxylb()
	{
		return this.xxylb;
	}

	public void setXxylb(String xxylb)
	{
		this.xxylb = xxylb;
	}

	@Column(name="ZJZMJ")
	public String getZjzmj()
	{
		return this.zjzmj;
	}

	public void setZjzmj(String zjzmj)
	{
		this.zjzmj = zjzmj;
	}

	@Column(name="BLLB")
	public String getBllb() {
		return bllb;
	}

	public void setBllb(String bllb) {
		this.bllb = bllb;
	}

	@Column(name="LXR")
	public String getLxr()
	{
		return this.lxr;
	}

	public void setLxr(String lxr)
	{
		this.lxr = lxr;
	}

	@Column(name="DWDM")
	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	@Column(name="PRINT_FLAG")
	public String getPrintFlag() {
		return printFlag;
	}

	public void setPrintFlag(String printFlag) {
		this.printFlag = printFlag;
	}

	@Column(name="TJDBH")
	public String getTjdbh() {
		return tjdbh;
	}

	public void setTjdbh(String tjdbh) {
		this.tjdbh = tjdbh;
	}

}
