package com.jshx.returnItem.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.dao.ReturnItemDao;

@Component("returnItemDao")
public class ReturnItemDaoImpl extends BaseDaoImpl implements ReturnItemDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findReturnItemByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findReturnItem(Map<String, Object> paraMap){
		return this.findListByHqlId("findReturnItemByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ReturnItem getById(String id)
	{
		return (ReturnItem)this.getObjectById(ReturnItem.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ReturnItem returnItem)
	{
		returnItem.setId(null);
		this.saveOrUpdateObject(returnItem);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ReturnItem returnItem)
	{
		this.saveOrUpdateObject(returnItem);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ReturnItem.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ReturnItem returnItem = (ReturnItem)this.getObjectById(ReturnItem.class, id);
		returnItem.setDelFlag(1);
		this.saveObject(returnItem);
	}
}
