package com.jshx.refundManager.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jizihao.service.JizihaoService;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.service.JtqdService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.pjjx.entity.Pjjx;
import com.jshx.pjjx.service.PjjxService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.refundManager.entity.RefundManager;
import com.jshx.refundManager.service.RefundManagerService;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

public class RefundManagerAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String dwmc;
	private String bianhao;
	private String xmmc;
	 private List<File> file1 ;  
	 private List<String> file1FileName ;
	public List<File> getFile1() {
		return file1;
	}

	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}

	public List<String> getFile1FileName() {
		return file1FileName;
	}

	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}

	/**
	 * 实体类
	 */
	private RefundManager refundManager = new RefundManager();

	/**
	 * 业务类
	 */
	@Autowired
	private RefundManagerService refundManagerService;
	@Autowired
	private JtqdService jtqdService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private GenericManager genericManager;
	/**
	 * 业务类
	 */
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	@Autowired
	private TfspbService tfspbService;
	@Autowired
	private XmxxbService xmxxbService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private ActivitiService activitiService;
    
    @Autowired
    private HistoryService historyService;
    @Autowired
    private UserService userService;
    @Autowired
    private FawenAttachService fawenAttachService;
    @Autowired
    private PaymentVoucherHisService  paymentVoucherHisService;
	@Autowired
	private JizihaoService jizihaoService;
    
    public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getBianhao() {
		return bianhao;
	}

	public void setBianhao(String bianhao) {
		this.bianhao = bianhao;
	}

	private String taskId;
    private String outcome;
    private String comment;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	
	private String allFileName;
	private String originFileName;
	private List<FawenAttach> attach;
	public String getAllFileName() {
		return allFileName;
	}

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	public void rebateList() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		
		if(!this.getLoginUser().getIsSuperAdmin()){
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			   paraMap.put("zsdw", zsdw.getZsdw());
	        }   
		
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|dwmc|csmj|ptyjmj|ptyjje|xmbzj|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = paymentItemHisService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != refundManager){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != refundManager.getSlbh()) && (0 < refundManager.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + refundManager.getSlbh().trim() + "%");
			}

			if ((null != refundManager.getXmmc()) && (0 < refundManager.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + refundManager.getXmmc().trim() + "%");
			}
		
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|xmmc|slbh|jsdw|xkzjzmj|jfjzmj|yjfje|tfbh|ptfsjbh|ghxkzbh|tfje|contact|phone|reason|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = refundManagerService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	
	public String rebateexecute()
	{
		return "success";
	}
	
	public void isExit()
	{
		try {
			//Map<String, Object> paraMap = new HashMap<String, Object>();
			//String slbh = (String) this.getRequest().getAttribute("slbh");
		//	paraMap.put("slbh", "%"+slbh+"%");
			String dwdm = zsdwService.getDwdm(this.getLoginUserDepartmentId());
			jizihaoService.updatejizihao(dwdm);
			getResponse().getWriter().println("y");
			
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}
	//退费记字号..
	public void isExitbh()
	{
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			refundManager.setZsdw(zsdw.getZsdw());
			if(zsdw!=null)
			{
				String bh=sdf.format(new Date())+zsdw.getZsdm()+jizihaoService.zijibyck(zsdw.getZsdm());
				getResponse().getWriter().println(bh);
			}else{
			getResponse().getWriter().println("y");
			}
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}

	
	public String refundManagerPrint()
	{
		refundManager =  refundManagerService.getById(ids);
		
		return "success";
	}
	
	/**
     * 启动退费流程
     */
    public String startWorkflow() {
        String loginUserId = this.getLoginUser().getLoginId();
        
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
		if(zsdw!=null)
		{
			refundManager.setTfbh(sdf.format(new Date())+zsdw.getZsdm()+jizihaoService.zijiby(zsdw.getZsdm()));
		}
        refundManager.setDelFlag(0);
        refundManagerService.save(refundManager);
        //将附件相关信息放到附件表中
        String path = SysPropertiesUtil.jdlj(this.getRequest())
				+ File.separator+ "uploads" +File.separator;
     // 写到指定的路径中  
        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
    	String fileName = "";
				if(file1!=null)
				{
				  for(int i = 0 ; i < file1.size() ; i++ )  
			        {  
					  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path,UUID.randomUUID().toString());
					  String attachType = jsonObject.getString(file1FileName.get(i));
					  FawenAttach att = new FawenAttach();
						att.setDelFlag(0);
						att.setAttachname(file1FileName.get(i));
						att.setAttachpath(fileName);
						att.setBizrowid(refundManager.getId());
						att.setCreateTime(new Date());
						att.setAttachType(attachType);
						att.setXmType("退费");
						att.setWdno(jsonObject1.getString(file1FileName.get(i)));
						fawenAttachService.save(att);
			             
			              
			        } 	
				}
		Tfspb tfspb = new Tfspb();
		tfspb.setDelFlag(0);
		tfspb.setJsdw(refundManager.getJsdw());
		tfspb.setXmmc(refundManager.getXmmc());
		tfspb.setSlbh(refundManager.getSlbh());
		//
		PaymentVoucherHis phis = paymentVoucherHisService.getPayMentByorderId(refundManager.getSlbh());
		if(phis!=null)
		{
		tfspb.setJksbh(phis.getVoucherCode());
		}else if(!"".equals(refundManager.getPtfsjbh())){
			tfspb.setJksbh(refundManager.getPtfsjbh());
		}
		tfspb.setGhxkmj(refundManager.getXkzjzmj());
		tfspb.setTfbh(refundManager.getTfbh());
		tfspb.setGhxkzbh(refundManager.getGhxkzbh());
		tfspb.setJfzjmhj(refundManager.getJfjzmj());
		tfspb.setYjfje(refundManager.getYjfje());
		tfspb.setTfmj(refundManager.getTfmj());
		tfspb.setTfje(refundManager.getTfje());
		tfspb.setLinkphone(refundManager.getContact()+'、'+refundManager.getPhone());
//		tfspb.setKhhzh(refundManager.getKhhname()+';'+refundManager.getKhhzh());
		tfspb.setKhhzh(refundManager.getKhhname());
		tfspb.setSuggest(refundManager.getSuggest());
		tfspb.setJbr(this.getLoginUser().getDisplayName());
		tfspb.setZsdw(refundManager.getZsdw());
		Xmxxb xmxxb = xmxxbService.getBySlbh(refundManager.getSlbh());
		if(xmxxb!=null)
		{
			tfspb.setZsfw(xmxxb.getZsfw());
		}
        String businessKey = refundManager.getId();
        Map<String, Object> variables = new HashMap<String, Object>();
       // variables.put("numDays", leaveDemo.getNumDays());
        try {
            identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
            ProcessInstance processInstance =runtimeService.startProcessInstanceByKey("tuifei", businessKey, variables);
             String proinstid = processInstance.getProcessInstanceId();
             tfspb.setGzlid(proinstid);
//           List<ProcessInstance> pi=  runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).list();
               
        } finally {
            identityService.setAuthenticatedUserId(null);
        }
        tfspbService.save(tfspb);
       
        return RELOAD;

    }

    public String handleTask() {
       Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessKey =  processInstance.getBusinessKey();
        refundManager= refundManagerService.getById(businessKey);
       
        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
        Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", refundManager.getId());
		paramMap.put("xmType", "退费");
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
        ActionContext.getContext().put("outcomeList", outcomeList);
        return SUCCESS;
    }

    public void submitTask() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> map = new HashMap<String, Object>();
            //User user = activitiService.getCreator(task.getProcessInstanceId());
          HistoricProcessInstance hisPi =  historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
          String userId =hisPi.getStartUserId();
          map.put("loginId", userId);
          User user =userService.findUserByLoginId(map);
          Map<String, Object> variables = new HashMap<String, Object>();
          variables.put("outcome", outcome); 
          if("驳回".equals(outcome))
          {
       	    ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        	   String businessKey =  processInstance.getBusinessKey();
        	 
               refundManager= refundManagerService.getById(businessKey);
               Map<String, String> paramMap = new HashMap<String, String>();
          		paramMap.put("bizrowid", refundManager.getId());
          		paramMap.put("xmType", "退费");
          		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
          		for(FawenAttach att:attach)
          		{
          			att.setDelFlag(1);
          			fawenAttachService.update(att);
          		}
               refundManager.setDelFlag(1);
               refundManagerService.update(refundManager);
               Tfspb tfspb=tfspbService.getBYslbh(refundManager.getSlbh());
               tfspb.setDelFlag(1);
               tfspbService.update(tfspb);
          }
          else
          {
            if("002001".equals(user.getDept().getDeptCode()))
            {
            	variables.put("fhuser", 1);
            }
            else
            {
            	variables.put("fhuser", 0);
            }
         } 
           
           
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }

    public String tohandleTask() {
    	
        Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         refundManager= refundManagerService.getById(businessKey);

         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         Set<String> myList =new HashSet<String>();
         for(String s:outcomeList)
         {
        	 myList.add(s);
         }
         outcomeList = new ArrayList(myList);
         Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", refundManager.getId());
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }
    
    public String toendhandleTask() {
    	
        Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         refundManager= refundManagerService.getById(businessKey);

         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         Set<String> myList =new HashSet<String>();
         for(String s:outcomeList)
         {
        	 myList.add(s);
         }
         outcomeList = new ArrayList(myList);
         Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", refundManager.getId());
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }
    public void tosubmitTask() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> map = new HashMap<String, Object>();
            //User user = activitiService.getCreator(task.getProcessInstanceId());
            HistoricProcessInstance hisPi =  historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String userId =hisPi.getStartUserId();
            map.put("loginId", userId);
            User user =userService.findUserByLoginId(map);

       
          Map<String, Object> variables = new HashMap<String, Object>();
            
            variables.put("outcome", outcome);   
            
	            if("002001".equals(user.getDept().getDeptCode()))
	            {
	            	variables.put("tfflag", 1);
	            }else{
	            	variables.put("tfflag", 0);
	            }
            
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }

    public void endsubmitTask() throws Exception{
        try {
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            Map<String, Object> map = new HashMap<String, Object>();
            SimpleDateFormat sdf =new SimpleDateFormat("yyyy");

       
          Map<String, Object> variables = new HashMap<String, Object>();
            
            variables.put("outcome", outcome);                      
           if("通过".equals(outcome))
           {
        	   Date d = new Date();
        	   ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
               String businessKey =  processInstance.getBusinessKey();
               refundManager= refundManagerService.getById(businessKey);
               Tfspb tfspb=tfspbService.getBYslbh(refundManager.getSlbh());
               tfspb.setIsend("1");
               tfspb.setCreateTime(d);
               Calendar cal=Calendar.getInstance();  
   			 cal.setTime(d);
   			int month = cal.get(Calendar.MONTH)+1;
   			if(month == 1 || month ==2 || month ==3){
   				tfspb.setSeason(sdf.format(d)+ "年01季度");
   	        }
   	        else if(month == 4 || month ==5 || month ==6){
   	        	tfspb.setSeason(sdf.format(d)+ "年02季度");
   	        }
   	        else if(month == 7 || month ==8 || month ==9){
   	        	tfspb.setSeason(sdf.format(d)+ "年03季度");
   	        }
   	        else if(month == 10 || month ==11 || month ==12){
   	        	tfspb.setSeason(sdf.format(d)+ "年04季度");
   	        }
               tfspbService.update(tfspb);
               String[] slbh = tfspb.getSlbh().split("\\|");
               for(int i=0;i<slbh.length;i++)
               {
	               Jtqd tfqd=new Jtqd();
	               tfqd.setDelFlag(0);
	               tfqd.setSlbh(slbh[i]);
	               tfqd.setPzlx("1");
	               tfqd.setXmmc(tfspb.getXmmc());
	               tfqd.setZsdw(tfspb.getZsdw());
	               String dwzm = zsdwService.getDwdmByzsdw(tfspb.getZsdw());
	               tfqd.setSequenceId(UUID.randomUUID().toString().replaceAll("-", ""));
	               tfqd.setZsdm(dwzm);
	               jtqdService.save(tfqd);
               }
           }
            
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		
			if((null != refundManager)&&(null != refundManager.getId()))
		    	refundManager = refundManagerService.getById(refundManager.getId());
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", refundManager.getId());
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		PaymentItemHis xmxxb  =null;
		if(StringUtils.isNotEmpty(ids.trim()))
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			String [] s = ids.substring(0, ids.lastIndexOf("|")).split("\\|");
			if(s.length==1)
			{
				
				 xmxxb = paymentItemHisService.getByOrderId(ids.substring(0, ids.lastIndexOf("|")));
					Map<String, Object> paramMap = new HashMap<String, Object>();
					paramMap.put("applyStatus","0");
					paramMap.put("orderId",ids.substring(0, ids.lastIndexOf("|")));
				 List<PaymentVoucherHis> pvh=paymentVoucherHisService.findPaymentVoucherHis(paramMap);
				 if(null!=pvh&&pvh.size()>0){
					 refundManager.setPtfsjbh(pvh.get(0).getVoucherCode());
				 }
				if(xmxxb!=null)
				{
					refundManager.setSlbh(xmxxb.getSlbh());
					refundManager.setJsdw(xmxxb.getDwmc());
					refundManager.setXmmc(xmxxb.getXmmc());
					refundManager.setYjfje(xmxxb.getPtyjje());
					refundManager.setJfjzmj(xmxxb.getPtyjmj());
					refundManager.setXkzjzmj(xmxxb.getCsmj());
					refundManager.setZsdw(xmxxb.getZsdw());
				}
			}
			else
			{
				xmxxb = paymentItemHisService.getByOrderId(s[0]);
				refundManager.setSlbh(ids.substring(0, ids.lastIndexOf("|")));
				refundManager.setJsdw(URLDecoder.decode(dwmc,"UTF-8"));
				refundManager.setXmmc(URLDecoder.decode(xmmc,"UTF-8"));
				refundManager.setZsdw(xmxxb.getZsdw());
				flag="add";
			}
			if(zsdw!=null)
			{
//				refundManager.setTfbh(sdf.format(new Date())+zsdw.getZsdm()+jizihaoService.zijiby(zsdw.getZsdm()));
			}
		}
	    return EDIT;
	}

	
	public String initEdit1() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
		Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
		refundManager.setZsdw(zsdw.getZsdw());
		if(zsdw!=null)
		{
//			refundManager.setTfbh(sdf.format(new Date())+zsdw.getZsdm()+jizihaoService.zijiby(zsdw.getZsdm()));
		}
		return EDIT;
	}
	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		
			refundManager.setDeptId(this.getLoginUserDepartmentId());
			refundManager.setDelFlag(0);
			refundManagerService.save(refundManager);
		
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != refundManager)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到refundManager中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			refundManagerService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	

	
	
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public RefundManager getRefundManager(){
		return this.refundManager;
	}

	public void setRefundManager(RefundManager refundManager){
		this.refundManager = refundManager;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    public String getDwmc() {
		return dwmc;
	}

	public void setDwmc(String dwmc) {
		this.dwmc = dwmc;
	}

	public String getXmmc() {
		return xmmc;
	}

	public void setXmmc(String xmmc) {
		this.xmmc = xmmc;
	}
	
}
