package com.jshx.refundManager.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.refundManager.entity.RefundManager;
import com.jshx.refundManager.dao.RefundManagerDao;

@Component("refundManagerDao")
public class RefundManagerDaoImpl extends BaseDaoImpl implements RefundManagerDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRefundManagerByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRefundManager(Map<String, Object> paraMap){
		return this.findListByHqlId("findRefundManagerByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RefundManager getById(String id)
	{
		return (RefundManager)this.getObjectById(RefundManager.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(RefundManager refundManager)
	{
		refundManager.setId(null);
		this.saveOrUpdateObject(refundManager);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(RefundManager refundManager)
	{
		this.saveOrUpdateObject(refundManager);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(RefundManager.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RefundManager refundManager = (RefundManager)this.getObjectById(RefundManager.class, id);
		refundManager.setDelFlag(1);
		this.saveObject(refundManager);
	}
}
