package com.jshx.recordvoucher.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.recordvoucher.entity.RecodeVoucher;
import com.jshx.recordvoucher.dao.RecodeVoucherDao;

@Component("recodeVoucherDao")
public class RecodeVoucherDaoImpl extends BaseDaoImpl implements RecodeVoucherDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRecodeVoucherByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRecodeVoucher(Map<String, Object> paraMap){
		return this.findListByHqlId("findRecodeVoucherByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RecodeVoucher getById(String id)
	{
		return (RecodeVoucher)this.getObjectById(RecodeVoucher.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(RecodeVoucher recodeVoucher)
	{
		recodeVoucher.setId(null);
		this.saveOrUpdateObject(recodeVoucher);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(RecodeVoucher recodeVoucher)
	{
		this.saveOrUpdateObject(recodeVoucher);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(RecodeVoucher.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		RecodeVoucher recodeVoucher = (RecodeVoucher)this.getObjectById(RecodeVoucher.class, id);
		recodeVoucher.setDelFlag(1);
		this.saveObject(recodeVoucher);
	}
}
