package com.jshx.quartz;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;

public class PaymentNoticeTask {

	protected static Logger logger = LoggerFactory.getLogger(PaymentNoticeTask.class); 
	
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private CktzsService cktzsService;
	@Autowired
	private GenericManager genericManager;
	@Autowired
	private DxpzService dxpzService;
	
	public void run(){
		try{
			Date date = new Date();
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);//设置当前日期
			calendar.add(Calendar.MONTH, -1);//月份减一
			Map<String,Object> paraMap = new HashMap<String,Object>();
			paraMap.put("dyriqi", calendar.getTime());
			paraMap.put("warnFlag", "0");
			List<PaymentItemPending> list = paymentItemPendingService.findPaymentItemPending(paraMap);
			for(PaymentItemPending bean : list){
				bean.setWarnFlag("1");
				Map<String,Object> paraMap2 = new HashMap<String,Object>();
				if ((null != bean.getSlbh()) && (0 < bean.getSlbh().trim().length())){
					paraMap2.put("slbh", "%" + bean.getSlbh().trim() + "%");
				}
				 List<Jktzs> jlist= jktzsService.findByAll(paraMap2);
				   Jktzs jk=jlist.get(0);
				   Xmxxb xmb=new Xmxxb();
			        xmb= xmxxbService.getById(jk.getXmbzj());
			    Cktzs ck= new Cktzs();
			    ck.setCreateTime(new Date());
			    ck.setDelFlag(0);
				ck.setSlbh(jk.getSlbh());
				ck.setXxbbh(jk.getXxbbh());
				ck.setXmbzj(jk.getXmbzj());
					ck.setDwmc(jk.getDwmc());
				ck.setXmmc(jk.getXmmc());
				ck.setXmdd(jk.getXmdd());
				ck.setCkbh(jk.getCkbh());
				ck.setDwdm(jk.getDwdm());
				ck.setGhxkz(jk.getGhxkz());
				ck.setZjzmj(jk.getZjzmj());
				ck.setCsptf(jk.getCsptf());
				ck.setJfmj(jk.getJfmj());
				ck.setJfje(jk.getJfje());
				ck.setMjmj(jk.getMjmj());
				ck.setMjje(jk.getMjje());
				//电子代码
				String tf=genericManager.getSN ("dzck");
				String dwdm=xmb.getDwdm();
				ck.setDzbh("ck"+xmb.getBllb()+dwdm+tf);
				
				ck.setLianxiren(jk.getLianxiren());
				ck.setPhone(jk.getPhone());
				if("1".equals(jk.getIsqtfy())){
					ck.setXqtyj(jk.getXqtyj());
					ck.setRfyj(jk.getRfyj());
					ck.setByyj(jk.getByyj());
					ck.setIsqtfy("1");
				}else{
					ck.setIsqtfy("0");
					
				}
				ck.setDkslh(jk.getDkslh());
				ck.setDkmj(jk.getDkmj());
				ck.setDycs("0");
				//状态:0未交款,1已交款
			    ck.setIsjk("0");
			    cktzsService.save(ck);
			    paymentItemPendingService.update(bean);				
				//插入催缴记录表
			    //短信
			    String neirong=xmb.getSlbh()+"-"+xmb.getXmmc()+"已超过缴费时间";
			    String phones=dxpzService.findbyywbm("002",xmb.getDwdm());
				if(!"".equals(phones)){
//					CommonAction.send(neirong, phones, "zidong","自动扫描发送");
					CommonAction.sendNewMessage(neirong, phones, "zidong","自动扫描发送");
				}
			}
		}catch(Exception e){
			logger.error(e.getMessage());
		}
//		System.out.println("催缴提醒！");
	}
}
