/**
 * 
 */

package com.jshx.quartz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.xmdrb.service.GenericManager;



/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: 2010</p>
 *
 * <p>Company: JiangSu HongXin</p>
 *
 * @author Chenmeng
 * @version 1.0
 * @create 2010-9-16
 */
public class DealTextTask 
{

    /**
     * 日志
     */
    private static Logger log = Logger.getLogger(DealTextTask.class);

    private static String TXT_PATH_ZH = null;
    private static String TXT_PATH_DK = null;
    private static String TXT_PATH_HK = null;
    private static String TXT_PATH_BIND = null;
    public static String TXT_DATE = null;
    public static String TXT_DATE_DK = null;
    private static boolean isRun = false;
    @Autowired
	private GenericManager genericManager;

    public DealTextTask()
    {
    }

    /**
     * execute
     *
     * @param jobExecutionContext JobExecutionContext
     * @throws JobExecutionException
     * @todo Implement this org.quartz.Job method
     */
    public void run() throws JobExecutionException
    {
        //判断任务定时器启动标志是否为正在启动
        if (false != isRun)
        {
            if (log.isDebugEnabled())
            {
                log.debug("定时DealTextTask任务正在执行，直接跳出本次任务执行");
            }
            return;
        }
        try
        {
            isRun = true;
            if (log.isDebugEnabled())
            {
                log.debug("定时DealTextTask任务开始执行");
            }
            lookup("E:\\txt");    
            if (log.isDebugEnabled())
            {
                log.debug("定时DealTextTask任务成功执行完毕");
            }
        }
        catch (Exception ex)
        {
            if (log.isEnabledFor(Level.ERROR))
            {
                log.error("定时DealTextTask任务发生异常：", ex);
            }
        }
        finally
        
        {
            isRun = false;           
        }

    }

    public  void lookup(String path)
    {   
       // GjjDao dao = GjjDaoImpl.getInstance();
		
        File dir = new File(path);
        if(!dir.exists()){
            if (log.isEnabledFor(Level.ERROR))
            {
                log.error("定时DealTextTask任务发生异常：未找到目录:" + path);
            }            
            return;
        }
        /*if (log.isDebugEnabled())
        {
            log.debug("定时DealTextTask任务发生lookup目录:" + path);
        } */
        File[] files = dir.listFiles();
        if (null != files)
        {
            for (int i = 0; i < files.length; i++)
            {
                if (files[i].isDirectory())
                {
                    lookup(files[i].getAbsolutePath());
                }
                else
                {
                    String filename = files[i].getName().toLowerCase();
                    if (filename.contains("gjjcx")&&filename.endsWith(".txt"))
                    {
                        TXT_DATE = null;
                        checkDate(filename);
                        TXT_PATH_ZH = files[i].getAbsolutePath(); 
                       // dao.deleteZh();
                       read(TXT_PATH_ZH);
                        rename(files[i],filename);
                    }
//                    else if (filename.contains(Env.TXT_NAME_DK)&&filename.endsWith(".txt"))
//                    {
//                        TXT_DATE_DK = null;
//                        checkDateDk(filename);
//                        TXT_PATH_DK = files[i].getAbsolutePath();
//                     //   dao.deleteDk();
//                     //   read(TXT_PATH_DK,dao);
//                        rename(files[i],filename);
//                    }
//                    else if (filename.contains(Env.TXT_NAME_HK)&&filename.endsWith(".txt"))
//                    {
//                        TXT_PATH_HK = files[i].getAbsolutePath();
//                       // read(TXT_PATH_HK,dao);
//                       // rename(files[i],filename);
//                    }
//                    else if (filename.contains(Env.TXT_NAME_BIND)&&filename.endsWith(".txt"))
//                    {
//                        if (log.isDebugEnabled())
//                        {
//                            log.debug("定时DealTextTask任务发生lookup文件:" + files[i].getAbsolutePath());
//                        } 
//                        TXT_PATH_BIND = files[i].getAbsolutePath();
//                       // read(TXT_PATH_BIND,dao);
//                        rename(files[i],filename);
//                    }
                }
            }
        }
        return ;
    }

    public  List<String[]> read(String path)
    {
        int all = 0;
        int rulefailure = 0;
        int addsuccess = 0;        
        List<String[]> list = new ArrayList<String[]>();
       
        //java的文件输入流对象
        InputStream is = null;
        BufferedReader br = null;
        try
        {
            is = new FileInputStream(path);
            //java的文本处理流
            br = new BufferedReader(new InputStreamReader(is,"GBK"));
            //BufferedReader br = new BufferedReader(new InputStreamReader(  new FileInputStream(file), "GBK"));// 编码转换
            //集合,使用集合比数组方便很多
            while (true)
            {
                //重复读数据   
                String record = br.readLine();
                String[] temp = null;
                //如果读到的内容为空,那么跳出重复读取
                if (record == null)
                {
                    if(list.size()>0){ 
                        if(list.get(0).length==10){                          
                          //  addsuccess+=dao.batchInsertZh(list);                           
                            list.clear();
                        } else if(list.get(0).length==19){                        
                         //   addsuccess+=dao.batchInsertDk(list);
                            list.clear();
                        } else if (list.get(0).length==7){
                            //addsuccess+=dao.batchInsertHk(list);方法暂未实现
                            list.clear();
                        } else if (list.get(0).length==2){
                         //   addsuccess+=dao.batchBind(list);
                            list.clear();
                        }                        
                        else {
                            rulefailure++;
                            if (log.isDebugEnabled())
                            {
                                log.debug(path+"文件中无效数据["+all+"]行 内容: "+ record);
                            }
                        }
                    }
                    break;
                }
                else
                {        
                    all++;
                    //把读取到的数据添加到集合中
                    //[1]:0803365118|常利浩|.|326.46|35.00|封存|199606|张家港工行受理处一|江苏华亿机械集团公司|
                    record = validate(record);
                    temp = record.split("\\|");
					
                    //System.out.println("temp.length:"+temp.length);                              
                    if(temp.length==10){
					System.out.println(temp[0]);
					System.out.println(temp[1]);
					System.out.println(temp[2]);
					System.out.println(temp[3]);
					System.out.println(temp[4]);
					System.out.println(temp[5]);
					System.out.println(temp[6]);
					System.out.println(temp[7]);
					System.out.println(temp[8]);
                        list.add(temp);                   
                        if(list.size()>=4){                          
                          addsuccess+=genericManager.batchInsertZh(list);
                           list.clear();
                        }
                    } else if(temp.length==19){
                        list.add(temp);                       
                        if(list.size()>=500){
                           // addsuccess+=dao.batchInsertDk(list);
                            list.clear();
                        }
                    } else if (temp.length==7){
                        //贷款帐号 还款日期 摘要 本次还款金额 本次还本金 本次还利息 本金余额 
                        //addsuccess+=dao.batchInsertHk(list);方法暂未实现
                        list.add(temp); 
                        list.clear();
                    } else if (temp.length==2){
                        list.add(temp);                       
                        if(list.size()>=500){
                           // addsuccess+=dao.batchBind(list);
                            list.clear();
                        }
                    }
                    else {
                        rulefailure++;
                        if (log.isDebugEnabled())
                        {
                            log.debug(path+"文件中无效数据["+all+"]行  length:["+temp.length+"] 内容: "+ record);
                        } 
                    }
                }
            }           
        }
        catch (FileNotFoundException e)
        {
            if (log.isEnabledFor(Level.ERROR))
            {
                log.error("定时DealTextTask任务发生异常：未找到文件" + path + " " + e);
            }            
        }
        catch (Exception e)
        {
            if (log.isEnabledFor(Level.ERROR))
            {
                log.error("定时DealTextTask任务发生异常：" + e);
            }           
        }
        finally{
            try
            {
                if(null!=is){
                    is.close();
                }
                if(null!=br){
                    br.close();
                }
            }
            catch (Exception e)
            {
                if (log.isEnabledFor(Level.ERROR))
                {
                    log.error("定时DealTextTask任务关闭IO发生异常：" + e);
                }
            }
            if (log.isEnabledFor(Level.ERROR))
            {
                log.error("定时DealTextTask任务处理文件："+ path +" 共["+all+"]条记录，无效记录["+rulefailure+"]条" +
                		"  有效记录["+(all-rulefailure)+"]条  添加成功记录["+(addsuccess)+"]条  " +
                				"添加失败记录["+(all-rulefailure-addsuccess)+"]条");
            }
        }
        return list;
    }   
    
    private static String validate(String str)
    {
        if(null != str && str.indexOf("||")>=0){
            return str.replace("||", "| |");
        }
        return str;        
    }
    
    private static void rename(File file,String filename)
    {
        File bak = new File("E:\\txt"+"\\temp");
        if(!bak.exists()){
            bak.mkdirs();
        }
        file.renameTo(new File(bak+"//"+filename+".BAK"));
    }
    //20100731gjjcx_zjg.txt
    public static boolean checkDate(String sourceDate)
    {
        if (sourceDate == null)
        {
            return false;
        }        
        try
        {
            String temp = sourceDate.substring(0,6);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
            dateFormat.setLenient(false);
            ////20100731gjjcx_zjg.txt
            dateFormat.parse(temp);//201007
            TXT_DATE = temp;
          //  SmsCmdDaoImpl.getInstance().update(TXT_DATE);
            return true;
        }
        catch (Exception e)
        {
        }
        return false;
    }
    
    //20100731gjjcx_zjg.txt
    public static boolean checkDateDk(String sourceDate)
    {
        if (sourceDate == null)
        {
            return false;
        }        
        try
        {
            String temp = sourceDate.substring(0,6);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
            dateFormat.setLenient(false);
            ////20100731gjjcx_zjg.txt
            dateFormat.parse(temp);//201007
            TXT_DATE_DK = temp;           
            return true;
        }
        catch (Exception e)
        {
        }
        return false;
    }
}
