package com.jshx.pzmx.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.billManager.entity.Indeticur;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.pjrk.service.PjrkService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.pzmx.entity.Pzmx;
import com.jshx.pzmx.service.PzmxService;
import com.neusoft.egov.utils.billendnumber;

public class PzmxAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Pzmx pzmx = new Pzmx();

	/**
	 * 业务类
	 */
	@Autowired
	private PzmxService pzmxService;
	
	@Autowired
	private PjrkService pjrkService;

	@Autowired
	private PaymentItemHisService paymentItemHisService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private String startNo;
	
	private String count;
	
	private String status;
	
	private String status2;
	
	private PaymentItemHis paymentItemHis;
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
		
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != pzmx){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != pzmx.getMxno()) && (0 < pzmx.getMxno().trim().length())){
				paraMap.put("mxno", "%" +pzmx.getMxno().trim()+ "%");
			}

			if ((null != pzmx.getZsdw()) && (0 < pzmx.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + pzmx.getZsdw().trim() + "%");
			}


			
			if ((null != pzmx.getIsprint()) && (0 < pzmx.getIsprint().trim().length())){
				paraMap.put("isprint", pzmx.getIsprint().trim());
			}
			
//			if ((null != ids) && (0 < ids.trim().length())){
//				paraMap.put("sequenceid", ids);
//			}
	
			if ((null != flag) && (0 < flag.length())){
				if(flag.equals("1")){
					paraMap.put("isrece","1");
					paraMap.put("state","0");
				}else{
					paraMap.put("isState","0");
				}
			}
			
//			if ((null != status) && (0 < status.length())){
//				if(status.equals("1")){
//					paraMap.put("state", "1");
//					
//				}
//				
//				if(status.equals("2")){
//					paraMap.put("isprint", "1");
//					paraMap.put("state", "0");
//				}			
//				
//				if(status.equals("3")){
//					paraMap.put("state", "2");
//		
//				}
//				
//				if(status.equals("4")){
//					paraMap.put("isprint", "0");
//				}	
//			}
//			
			if ((null != status2) && (0 < status2.length())){
				if(status2.equals("1")){
					paraMap.put("state", "1");
				}
				
				
				if(status2.equals("2")){
					paraMap.put("state", "0");
				}			
				
				if(status2.equals("3")){
					paraMap.put("state", "2");	
				}					
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|mxno|isrece|state|lytime|bmzj|person|isprint|zsdw|syDate|hsDate|zfDate|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = pzmxService.findByPage(pagination, paraMap);
		
		List<Pzmx> pzmxList= pagination.list;
		
		for(Pzmx pzmx:pzmxList){
			pzmx.setMxno(pzmx.getMxno().substring(0, 7));
		}
		
		pagination.list=pzmxList;
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != pzmx)&&(null != pzmx.getId()))
			pzmx = pzmxService.getById(pzmx.getId());
		
		return VIEW;
	}

	
	
	
	public String pzjxView() throws Exception{
		paymentItemHis=paymentItemHisService.getByZslxdbh(ids);
		
		return SUCCESS;
	}
	
	/**
	 * 初始化修改信息
	 */

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{

		pzmx.setSequenceid(ids);;
	    return EDIT;
	}
	
	public String execute()
	{
		ids =this.getRequestParameter("ids");
		return SUCCESS;
	}
	
	public String execute1()
	{
		ids =this.getRequestParameter("ids");
		return SUCCESS;
	}
	
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != pzmx)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到pzmx中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			pzmxService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	
	public void isExit()
	{
		 JSONObject jsonObject = new JSONObject();
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		 Map<String, Object> paraMap1 = new HashMap<String, Object>();

		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			String count = (String) this.getRequest().getParameter("xxxx");
			String no = (String) this.getRequest().getParameter("no");
			no=buwei(no,no.length());
			paraMap.put("mxno","%" + no+"%");
			paraMap.put("sequenceid",ids);
			paraMap.put("isrece","0");
			Pzmx pzmx=	pzmxService.findPzmxByNo(paraMap);
			
			if(pzmx==null)
			{
				jsonObject.put("status", "y");
				jsonObject.put("info","开始号段"+no.substring(0,7)+"已经被领取或者不存在,请确认!");
				getResponse().getWriter().println(jsonObject.toString());	
			}else
			{
				paraMap1.put("sequenceid",ids);
				paraMap1.put("isrece", "0");
				int number = pzmxService.findcountByMap(paraMap1);
				//int number = Integer.parseInt(pjrkService.getById(ids).getEndno())-Integer.parseInt(no)+1;
				if(Integer.parseInt(count)>number)
				{
					jsonObject.put("status", "y");
					jsonObject.put("info","领取的票据张数不能超过"+number+"张");
					
					getResponse().getWriter().println(jsonObject.toString());
				}else
				{
					jsonObject.put("status", "n");
					getResponse().getWriter().println(jsonObject.toString());
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void isExit2()
	{
		 JSONObject jsonObject = new JSONObject();
		 Map<String, Object> paraMap = new HashMap<String, Object>();

		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			String mxno = (String) this.getRequest().getParameter("mxno");
//	
//			mxno=buwei(mxno,mxno.length());
//			paraMap.put("mxno","%" + mxno+"%");
//			paraMap.put("isrece","1");
//			paraMap.put("isprint","0");
//			Pzmx pzmx=	pzmxService.findPzmxByNo(paraMap);
			getResponse().getWriter().println(jsonObject.toString());
			
//			if(pzmx==null)
//			{
//				jsonObject.put("status", "y");
//				jsonObject.put("info","该号码不可用");
//				getResponse().getWriter().println(jsonObject.toString());	
//			}else
//			{
//				jsonObject.put("status", "n");
//				getResponse().getWriter().println(jsonObject.toString());
//
//			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	
	public void findEndNo() throws Exception
	{
		JSONObject jsonObject = new JSONObject();
		getResponse().setContentType("application/json;charset=UTF-8");
		getResponse().setCharacterEncoding("utf-8");
		getResponse().setHeader("Charset", "utf-8");
		getResponse().setHeader("Cache-Control", "no-cache");
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		try{
			String count = (String) this.getRequest().getParameter("xxxx");
			String startNo = (String) this.getRequest().getParameter("no");
			int length =startNo.substring(0, 7).length();
			int end = Integer.parseInt(startNo.substring(0, 7))+Integer.parseInt(count)-1;
			for(int i=Integer.parseInt(startNo.substring(0, 7));i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("mxno", "%" +no+"%");
				paraMap.put("sequenceid", ids);
				paraMap.put("isrece", "0");
				Pzmx pzmx =pzmxService.findPzmxByNo(paraMap);
				if(pzmx==null)
				{
					end++;
				}
			}
			String endNO = String.valueOf(end);
			endNO= buwei(endNO,length);
			jsonObject.put("result", true);
			jsonObject.put("info",endNO.substring(0, 7));
			getResponse().getWriter().println(jsonObject.toString());	
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	
	
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no+billendnumber.getCode(no);
		 return s;
	}
	
	

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
			String stno =startNo.substring(0, 7);
			int length =startNo.length();
			int end = Integer.parseInt(stno)+Integer.parseInt(count)-1;
			
			for(int i=Integer.parseInt(stno);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("mxno", "%" +no+"%");
				paraMap.put("sequenceid", pzmx.getSequenceid());
				paraMap.put("isrece", "0");
				Pzmx pzmx =pzmxService.findPzmxByNo(paraMap);
				if(pzmx!=null)
				{
					pzmx.setIsrece("1");
					pzmx.setPerson(this.pzmx.getPerson());
					pzmx.setIsprint("0");
					pzmx.setZsdw(this.pzmx.getZsdw());
					pzmx.setDeptId(this.getLoginUserDepartmentId());
					pzmx.setLytime(sdf.format(new Date()));
					pzmxService.update(pzmx);
				}
			}
		return RELOAD;
	}
	
	public String pzmxhuishou() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		FileInputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
			paraMap.put("mxno", "%" +ids+"%");
			Pzmx pzmx=pzmxService.findPzmxByNo(paraMap);
			pzmx.setHsDate(sdf.format(new Date()));
			pzmx.setState("1");
			pzmxService.update(pzmx);
		return RELOAD;
	}
	
	/**
	 * 删除信息 票据作废
	 */
	public String pzmxzuofei() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	    try{
	    	paraMap.put("mxno", "%" +ids+"%");
	    	Pzmx pzmx=pzmxService.findPzmxByNo(paraMap);
	    	pzmx.setZfDate(sdf.format(new Date()));
			pzmx.setState("2");
			pzmxService.update(pzmx);
	    	
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String pzmxhuishou1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	    try{
			paraMap.put("mxno", "%" +ids+"%");
			Pzmx pzmx=pzmxService.findPzmxByNo(paraMap);
			pzmx.setHsDate(sdf.format(new Date()));
			pzmx.setState("1");
			pzmxService.update(pzmx);
	    	
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Pzmx getPzmx(){
		return this.pzmx;
	}

	public void setPzmx(Pzmx pzmx){
		this.pzmx = pzmx;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getStartNo() {
		return startNo;
	}

	public void setStartNo(String startNo) {
		this.startNo = startNo;
	}

	public String getCount() {
		return count;
	}

	public void setCount(String count) {
		this.count = count;
	}

	public PaymentItemHis getPaymentItemHis() {
		return paymentItemHis;
	}

	public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
		this.paymentItemHis = paymentItemHis;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatus2() {
		return status2;
	}

	public void setStatus2(String status2) {
		this.status2 = status2;
	}
       
    
}
