package com.jshx.printhis.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.printhis.dao.PrintHisDao;
import com.jshx.printhis.entity.PrintHis;
import com.jshx.printhis.service.PrintHisService;

@Service("printHisService")
public class PrintHisServiceImpl extends BaseServiceImpl implements PrintHisService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("printHisDao")
	private PrintHisDao printHisDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return printHisDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PrintHis getById(String id)
	{
		return printHisDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PrintHis printHis)
	{
		printHisDao.save(printHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PrintHis printHis)
	{
		printHisDao.update(printHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=printHisDao.findPrintHis(paraMap);
		
		printHisDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    printHisDao.deleteWithFlag(id);
			}
		}
	}


	@Override
	public PrintHis getPrintHisByxmbzj(String id) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xmbzj", id);
		PrintHis guidang =(PrintHis) printHisDao.findObjectByFieldsMap(PrintHis.class, paraMap); 
		return guidang;
	}
}
