package com.jshx.pjrk.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.common.utils.ValidUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.lsfc.entity.Lsfc;
import com.jshx.lsfc.service.LsfcService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.pjrk.entity.Pjrk;
import com.jshx.pjrk.service.PjrkService;
import com.jshx.pzmx.entity.Pzmx;
import com.jshx.pzmx.service.PzmxService;
import com.jshx.xmdrb.entity.Xmdrb;
import com.jshx.xmxxb.entity.Xmxxb;
import com.neusoft.egov.utils.billendnumber;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class PjrkAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Pjrk pjrk = new Pjrk();

	/**
	 * 业务类
	 */
	@Autowired
	private PjrkService pjrkService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 业务类
	 */
	@Autowired
	private PzmxService pzmxService ;
	
	private File importFile;
	
	@Autowired
	private LsfcService lsfcService;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != pjrk){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != pjrk.getStartno()) && (0 < pjrk.getStartno().trim().length())){
				paraMap.put("startno", "%" + pjrk.getStartno().trim() + "%");
			}
			if ((null != pjrk.getRkDate()) && (0 < pjrk.getRkDate().trim().length())){
				paraMap.put("rkDate", "%"+ pjrk.getRkDate().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|endno|startno|rkDate|by1|totalCount|useCount|notUseCount|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = pjrkService.findByPage(pagination, paraMap);
		List<Pjrk> pjrkList = pagination.list;
		for(Pjrk pjrk:pjrkList){
			pjrk.setStartno(pjrk.getStartno().substring(0, 7));
			pjrk.setEndno(pjrk.getEndno().substring(0, 7));
			pjrk.setTotalCount(Integer.parseInt(pjrk.getEndno())-Integer.parseInt(pjrk.getStartno())+1);
			
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("isrece", "1");
			paraMap1.put("sequenceid", pjrk.getBy1());

			pjrk.setUseCount(pzmxService.findcountByMap(paraMap1));
			pjrk.setNotUseCount(pjrk.getTotalCount()-pjrk.getUseCount());
			
		}
		pagination.list=pjrkList;
	
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != pjrk)&&(null != pjrk.getId()))
			pjrk = pjrkService.getById(pjrk.getId());
		if(pjrk!=null){
			if(pjrk.getStartno()!=null&&pjrk.getEndno()!=null){
				pjrk.setStartno(pjrk.getStartno().substring(0, 7));
				pjrk.setEndno(pjrk.getEndno().substring(0, 7));
			}
		}

		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		List<Pzmx>  list = new ArrayList<Pzmx>();
		FileInputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			String startNo =pjrk.getStartno();
			String endNo = pjrk.getEndno();
			int count = Integer.parseInt(endNo)-Integer.parseInt(startNo)+1;
			if(count>10000)
			{
				throw new Exception("一次最多只能入库一万张！");
			}
			int length =pjrk.getStartno().length();
			int end = Integer.valueOf(pjrk.getEndno());
			String uuid =UUID.randomUUID().toString().replaceAll("-", "");
			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				Pzmx pzmx = new Pzmx();
				pzmx.setDelFlag(0);
				pzmx.setIsrece("0");
				pzmx.setMxno(no);
				pzmx.setIsprint("0");	
				pzmx.setState("0");
				pzmx.setRktime(sdf.format(new Date()));
				pzmx.setSequenceid(uuid);
				list.add(pzmx);
				//billManagerService.save(indeticur);
			}
			pzmxService.batchupdate(list);
			pjrk.setDeptId(this.getLoginUserDepartmentId());
			pjrk.setDelFlag(0);
			pjrk.setEndno(endNo+billendnumber.getCode(endNo));
			pjrk.setRkDate(sdf.format(new Date()));
			pjrk.setStartno(startNo+billendnumber.getCode(startNo));
			pjrk.setBy1(uuid);;
			pjrkService.save(pjrk);
			
			
			
			
//			if (null != importFile) {
//				String message = null;
//				Workbook workBook = null;
//				try {
//					try {
//						workBook = Workbook.getWorkbook(importFile);
//					} catch (Exception e) {
//						message = "解析上传文件信息异常,请检查.";
//					}
//
//					if (null == workBook) {
//						message = "打开上传文件信息失败,请检查.";
//					}
//
//					try {
//						Sheet[] sheets = workBook.getSheets();
//						if (null == sheets || 0 == sheets.length) {
//							message = "上传文件工作薄信息为空,请检查.";
//						}
//						Sheet sheet = sheets[1];
//						Cell[] cells;
//						long rowCount = ValidUtils.getRealRows(sheet, sheet.getRows(), sheet.getColumns());
//						if (rowCount <= 1) {
//							message = "上传文件中无数据,请检查.";
//						}
//						List<Lsfc> list1 = new ArrayList<Lsfc>();
//						for (int i = 1; i < rowCount; i++) {
//							Lsfc bean = null;
//							cells = sheet.getRow(i);
//							if (null == cells || cells.length == 0) {
//								continue;
//							}
//							bean = new Lsfc();
//							bean.setCreateTime(new Date());
//							bean.setDeptId(this.getLoginUserDepartmentId());
//							bean.setDelFlag(0);
//							bean.setId("");
//							bean.setCreateUserID("");
//							bean.setUpdateUserID("");
//							//原始表导入状态,0:导入未划分,1:已整合入项目基础表,2:与已整合的信息编号相同,999:异常代码
//							
//							if(null==cells[0].getContents().trim()){
//								bean.setZsdw("");
//							}else{
//								bean.setZsdw(cells[0].getContents().trim());
//							}
//							
//							if(null==cells[1].getContents().trim()){
//								bean.setDwdz("");
//							}else{	
//								bean.setDwdz(cells[1].getContents().trim());
//							}	
//
//							if(null==cells[2].getContents().trim()){
//								bean.setXmdz("");
//							}else{
//							bean.setXmdz(cells[2].getContents().trim());
//							}
//							
//							if(null==cells[3].getContents().trim()){
//								bean.setXmmc("");
//							}else{
//							bean.setXmmc(cells[3].getContents().trim());
//							}
//							
//							
//							if(null==cells[4].getContents().trim()){
//								bean.setBllb("");
//							}else{
//								bean.setBllb(cells[4].getContents().trim());
//							}
//							
//							
//							if(null==cells[5].getContents().trim()){
//								bean.setDqlb("");
//							}else{
//							bean.setDqlb(cells[5].getContents().trim());
//							}
//							
//							if(null==cells[6].getContents().trim()){
//								bean.setSpxx("");
//							}else{
//							bean.setSpxx(cells[6].getContents().trim());
//							
//							}
//							
//							if(null==cells[7].getContents().trim()){
//								bean.setZjmj("");
//							}else{
//								bean.setZjmj(cells[7].getContents().trim());
//							}
//							
//							if(null==cells[8].getContents().trim()){
//								bean.setZjdz("");
//							}else{
//							bean.setZjdz(cells[8].getContents().trim());
//							}
//							
//							if(null==cells[9].getContents().trim()){
//								bean.setJxyf("");
//							}else{
//							bean.setJxyf(cells[9].getContents().trim());
//							}
//							
//							
//							if(null==cells[10].getContents().trim()){
//								bean.setYwyf("");
//							}else{
//							bean.setYwyf(cells[10].getContents().trim());
//							}
//							
//							if(null==cells[11].getContents().trim()){
//								bean.setYyyf("");
//							}else{
//							bean.setYyyf(cells[11].getContents().trim());
//							}
//							
//							if(null==cells[12].getContents().trim()){
//								bean.setFsyf("");
//							}else{
//							bean.setFsyf(cells[12].getContents().trim());
//							}
//							
//							
//							if(null==cells[13].getContents().trim()){
//								bean.setScyf("");
//							}else{
//							bean.setScyf(cells[13].getContents().trim());
//							}
//							
//							if(null==cells[14].getContents().trim()){
//								bean.setYjje("");
//							}else{
//								bean.setYjje(cells[14].getContents().trim());
//							}
//							
//							if(null==cells[15].getContents().trim()){
//								bean.setYmje("");
//							}else{
//							bean.setYmje(cells[15].getContents().trim());
//							}
//							
//							if(null==cells[16].getContents().trim()){
//								bean.setAwj("");
//							}else{
//							bean.setAwj(cells[16].getContents().trim());
//							}
//							
//							if(null==cells[17].getContents().trim()){
//								bean.setAbwd("");
//							}else{
//							bean.setAbwd(cells[17].getContents().trim());
//							}
//							
//							if(null==cells[18].getContents().trim()){
//								bean.setHj1("");
//							}else{
//							bean.setHj1(cells[18].getContents().trim());
//							}
//							
//							
//							if(null==cells[19].getContents().trim()){
//								bean.setCd1("");
//							}else{
//							bean.setCd1(cells[19].getContents().trim());
//							}
//							
//							if(null==cells[20].getContents().trim()){
//								bean.setSc1("");
//							}else{
//							bean.setSc1(cells[20].getContents().trim());
//							}
//							
//							if(null==cells[21].getContents().trim()){
//								bean.setSfrq("");
//							}else{
//							bean.setSfrq(cells[21].getContents().trim());
//							
//							}
//							
//							if(null==cells[22].getContents().trim()){
//								bean.setSfhj("");
//							}else{
//							bean.setSfhj(cells[22].getContents().trim());
//							}
//							
//							if(null==cells[23].getContents().trim()){
//								bean.setDah("");
//							}else{
//							bean.setDah(cells[23].getContents().trim());
//							}
//							if(null==cells[24].getContents().trim()){
//								bean.setBz1("");
//							}else{
//							bean.setBz1(cells[24].getContents().trim());
//							}
//							if(null==cells[0].getContents().trim()){
//								bean.setCfwz("");
//							}else{
//							bean.setCfwz(cells[25].getContents().trim());
//							}
//					
//
//							list1.add(bean);
//						}
//						// 批量插入数据，要求数据必须全部满足要求，否则一律不导入。
//						
//						
//						//this.xmdrbService.saveList(list);
//						if (null != list && list.size() > 0) {
//		
//							for (Lsfc bean : list1) {
//								lsfcService.save(bean);
//							}
//						}
//		
//					} catch (Exception ex) {
//						message = "出错了！" + ex.getMessage();
//					}
//				} catch (Exception e) {
//					workBook.close();
//				}
//				if (null != message) {
//					this.getRequest().setAttribute("message", message);
//				}
//				workBook.close();
//			} else {
//				this.getRequest().setAttribute("message", "获取上传文件信息失败,请重新上传文件.");
//			}
		}else{
			pjrkService.update(pjrk);
		}
		
		return RELOAD;
	}

	
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no+billendnumber.getCode(no);
		 return s;
	}
	
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != pjrk)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到pjrk中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			pjrkService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	
	public void isExit() throws Exception
	{
		 JSONObject jsonObject = new JSONObject();
		getResponse().setContentType("application/json;charset=UTF-8");
		getResponse().setCharacterEncoding("utf-8");
		getResponse().setHeader("Charset", "utf-8");
		getResponse().setHeader("Cache-Control", "no-cache");
		try
		{
			String no = ids+billendnumber.getCode(ids);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("mxno", "%" +no+"%");
			Pzmx pzmx = pzmxService.findPzmxByNo(paraMap);
			if(pzmx!=null)
			{
				jsonObject.put("result", true);
				jsonObject.put("info", "票据号"+ids+"已经存在！");
				getResponse().getWriter().println(jsonObject.toString());
			}else
			{
				jsonObject.put("result", false);
				getResponse().getWriter().println(jsonObject.toString());
			}
		}catch(Exception e)
		{
			jsonObject.put("result", true);
			jsonObject.put("info", e.getMessage());
			getResponse().getWriter().println(jsonObject.toString());
		}
	}

	
	
	
	
	public File getImportFile() {
		return importFile;
	}

	public void setImportFile(File importFile) {
		this.importFile = importFile;
	}

	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Pjrk getPjrk(){
		return this.pjrk;
	}

	public void setPjrk(Pjrk pjrk){
		this.pjrk = pjrk;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
