package com.jshx.paymentItemPending.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.dao.PaymentItemPendingDao;

@Component("paymentItemPendingDao")
public class PaymentItemPendingDaoImpl extends BaseDaoImpl implements PaymentItemPendingDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentItemPendingByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemPending(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemPendingByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemPending getById(String id)
	{
		return (PaymentItemPending)this.getObjectById(PaymentItemPending.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemPending paymentItemPending)
	{
		paymentItemPending.setId(null);
		this.saveOrUpdateObject(paymentItemPending);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemPending paymentItemPending)
	{
		this.saveOrUpdateObject(paymentItemPending);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentItemPending.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentItemPending paymentItemPending = (PaymentItemPending)this.getObjectById(PaymentItemPending.class, id);
		paymentItemPending.setDelFlag(1);
		this.saveObject(paymentItemPending);
	}
}
