package com.jshx.paymentItemDelayHis.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="PAYMENT_ITEM_DELAY_HIS")
public class PaymentItemDelayHis extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 项目表主键
	 */
	private String xmbzj;

	/**
	 * 受理编号
	 */
	private String slbh;

	/**
	 * 单位名称
	 */
	private String dwmc;

	/**
	 * 项目名称
	 */
	private String xmmc;

	/**
	 * 测算面积
	 */
	private String csmj;

	/**
	 * 执收单位
	 */
	private String zsdw;
	
	/**
	 * 单位代码
	 */
	private String dwdm;

	/**
	 * 实际缴费金额
	 */
	private String sjje;

	/**
	 * 相关银行缴费记录
	 */
	private String accountbankId;
	
	/**
	 * 是否允许打印一般缴款书
	 */
	private String printFlag;
	
	/**
	 * 非税状态  0：可上传 1：不可上传
	 */
	private String nonTaxStatus;

	
	public PaymentItemDelayHis(){
	}
	
	public PaymentItemDelayHis(String id, String slbh, String dwmc, String xmmc, String csmj, String zsdw, String accountbankId){
this.id = id;

this.slbh = slbh;

this.dwmc = dwmc;

this.xmmc = xmmc;

this.csmj = csmj;

this.zsdw = zsdw;

this.accountbankId = accountbankId;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="XMBZJ")
	public String getXmbzj()
	{
		return this.xmbzj;
	}

	public void setXmbzj(String xmbzj)
	{
		this.xmbzj = xmbzj;
	}

	@Column(name="SLBH")
	public String getSlbh()
	{
		return this.slbh;
	}

	public void setSlbh(String slbh)
	{
		this.slbh = slbh;
	}

	@Column(name="DWMC")
	public String getDwmc()
	{
		return this.dwmc;
	}

	public void setDwmc(String dwmc)
	{
		this.dwmc = dwmc;
	}

	@Column(name="XMMC")
	public String getXmmc()
	{
		return this.xmmc;
	}

	public void setXmmc(String xmmc)
	{
		this.xmmc = xmmc;
	}

	@Column(name="CSMJ")
	public String getCsmj()
	{
		return this.csmj;
	}

	public void setCsmj(String csmj)
	{
		this.csmj = csmj;
	}

	@Column(name="ZSDW")
	public String getZsdw()
	{
		return this.zsdw;
	}

	public void setZsdw(String zsdw)
	{
		this.zsdw = zsdw;
	}

	@Column(name="ACCOUNTBANK_ID")
	public String getAccountbankId()
	{
		return this.accountbankId;
	}

	public void setAccountbankId(String accountbankId)
	{
		this.accountbankId = accountbankId;
	}

	@Column(name="PRINT_FLAG")
	public String getPrintFlag() {
		return printFlag;
	}

	public void setPrintFlag(String printFlag) {
		this.printFlag = printFlag;
	}

	@Column(name="DWDM")
	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	@Column(name="SJJE")
	public String getSjje() {
		return sjje;
	}

	public void setSjje(String sjje) {
		this.sjje = sjje;
	}
	
	@Column(name="NONTAX_STATUS")
	public String getNonTaxStatus() {
		return nonTaxStatus;
	}

	public void setNonTaxStatus(String nonTaxStatus) {
		this.nonTaxStatus = nonTaxStatus;
	}

}
