package com.jshx.paymentItemDelay.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.dao.PaymentItemDelayDao;

@Component("paymentItemDelayDao")
public class PaymentItemDelayDaoImpl extends BaseDaoImpl implements PaymentItemDelayDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentItemDelayByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemDelay(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemDelayByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemDelay getById(String id)
	{
		return (PaymentItemDelay)this.getObjectById(PaymentItemDelay.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemDelay paymentItemDelay)
	{
		paymentItemDelay.setId(null);
		this.saveOrUpdateObject(paymentItemDelay);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemDelay paymentItemDelay)
	{
		this.saveOrUpdateObject(paymentItemDelay);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentItemDelay.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentItemDelay paymentItemDelay = (PaymentItemDelay)this.getObjectById(PaymentItemDelay.class, id);
		paymentItemDelay.setDelFlag(1);
		this.saveObject(paymentItemDelay);
	}
}
