/** 
 * JsonUtil.java Created on Jun 30, 2009
 * Copyright 2009@JSHX. 
 * All right reserved. 
 */
package com.jshx.mobile.utils;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.JavaIdentifierTransformer;

/**
 * 用来输出JSON字符串，交给Javascript在页面上进行处理。支持JSON对象的嵌套，支持数组
 * 
 * @Time 2:54:56 PM
 */
public class JsonUtil {

	private Map<String, Object> jsonMap = new HashMap<String, Object>();
	private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

	public void clear() {
		jsonMap.clear();
	}

	/**
	 * 添加元素 <br/>
	 * 邮件：wallimn@sohu.com<br/>
	 * 博客：http://blog.csdn.net/wallimn<br/>
	 * 参数：<br/>
	 * 
	 * @param key
	 * @param value
	 *            　支持简单类型（即原生类型的包装器类）、bean对象、List<Object>、Map<String,Object>以及数组
	 * @return
	 */
	public Map<String, Object> put(String key, Object value) {
		jsonMap.put(key, value);
		return jsonMap;
	}

	// 判断是否要加引号
	private static boolean isNoQuote(Object value) {
		return (value instanceof Integer || value instanceof Boolean
				|| value instanceof Double || value instanceof Float
				|| value instanceof Short || value instanceof Long || value instanceof Byte);
	}

	private static boolean isQuote(Object value) {
		return (value instanceof String || value instanceof Character);
	}

	@SuppressWarnings("unchecked")
	@Override
	/*
	 * 返回形如{'apple':'red','lemon':'yellow'}的字符串
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("{");
		Set<Entry<String, Object>> set = jsonMap.entrySet();
		for (Entry<String, Object> entry : set) {
			Object value = entry.getValue();
			if (value == null) {
				continue;// 对于null值，不进行处理，页面上的js取不到值时也是null
			}
			sb.append("'").append(entry.getKey()).append("':");
			if (value instanceof JsonUtil) {
				sb.append(value.toString());
			} else if (isNoQuote(value)) {
				sb.append(value);
			} else if (value instanceof Date) {
				sb.append("'").append(formatter.format(value)).append("'");
			} else if (isQuote(value)) {
				sb.append("'").append(value).append("'");
			} else if (value.getClass().isArray()) {
				sb.append(ArrayToStr(value));
			} else if (value instanceof Map) {
				sb.append(fromObject((Map<String, Object>) value).toString());
			} else if (value instanceof List) {
				sb.append(ListToStr((List<Object>) value));
			} else {
				sb.append(fromObject(value).toString());
			}
			sb.append(",");
		}
		int len = sb.length();
		if (len > 1) {
			sb.delete(len - 1, len);
		}
		sb.append("}");
		return sb.toString();
	}

	public static String ArrayToStr(Object array) {
		if (!array.getClass().isArray())
			return "[]";
		StringBuffer sb = new StringBuffer();
		sb.append("[");
		int len = Array.getLength(array);
		Object v = null;
		for (int i = 0; i < len; i++) {
			v = Array.get(array, i);
			if (v instanceof Date) {
				sb.append("'").append(formatter.format(v)).append("'").append(
						",");
			} else if (isQuote(v)) {
				sb.append("'").append(v).append("'").append(",");
			} else if (isNoQuote(v)) {
				sb.append(i).append(",");
			} else {
				sb.append(fromObject(v)).append(",");
			}
		}
		len = sb.length();
		if (len > 1)
			sb.delete(len - 1, len);
		sb.append("]");
		return sb.toString();
	}

	@SuppressWarnings("unchecked")
	public static String ListToStr(List<Object> list) {
		if (list == null)
			return null;
		StringBuffer sb = new StringBuffer();
		sb.append("[");
		Object value = null;
		for (java.util.Iterator<Object> it = list.iterator(); it.hasNext();) {
			value = it.next();
			if (value instanceof Map) {
				sb.append(fromObject((Map) value).toString()).append(",");
			} else if (isNoQuote(value)) {
				sb.append(value).append(",");
			} else if (isQuote(value)) {
				sb.append("'").append(value).append("'").append(",");
			} else {
				sb.append(fromObject(value).toString()).append(",");
			}
		}
		int len = sb.length();
		if (len > 1)
			sb.delete(len - 1, len);
		sb.append("]");
		return sb.toString();
	}

	/**
	 * 从一个bean装载数据，返回一个JsonUtil对象。 <br/>
	 * 邮件：wallimn@sohu.com<br/>
	 * 博客：http://blog.csdn.net/wallimn<br/>
	 * 参数：<br/>
	 * 
	 * @param object
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static JsonUtil fromObject(Object bean) {
		JsonUtil json = new JsonUtil();
		if (bean == null)
			return json;
		Class cls = bean.getClass();
		Field[] fs = cls.getDeclaredFields();
		Object value = null;
		String fieldName = null;
		Method method = null;
		int len = fs.length;
		for (int i = 0; i < len; i++) {
			fieldName = fs[i].getName();
			try {
				method = cls.getMethod(getGetter(fieldName), (Class[]) null);
				value = method.invoke(bean, (Object[]) null);
			} catch (Exception e) {
				// System.out.println(method.getName());
				// e.printStackTrace();
				continue;
			}
			json.put(fieldName, value);
		}
		return json;
	}

	/**
	 * 从Map中装载数据 <br/>
	 * 作者：wallimn　时间：2009-2-5　下午04:05:04<br/>
	 * 邮件：wallimn@sohu.com<br/>
	 * 博客：http://blog.csdn.net/wallimn<br/>
	 * 参数：<br/>
	 * 
	 * @param map
	 * @return
	 */
	public static JsonUtil fromObject(Map<String, Object> map) {
		JsonUtil json = new JsonUtil();
		if (map == null)
			return json;
		json.getMap().putAll(map);
		return json;
	}

	private static String getGetter(String property) {
		return "get" + property.substring(0, 1).toUpperCase()
				+ property.substring(1, property.length());
	}

	public Map<String, Object> getMap() {
		return this.jsonMap;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println(getSuccessJson().toString());
	}

	public static String getInvalidParaJson(String errorMsg) {
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", Constant.RESULT_FAIL);
		response.put("TSR_MSG", Constant.PARA_ERROR);
		return response.toString();
	}

	@SuppressWarnings("unchecked")
	public static JsonConfig getDefaultConfig(Class objClass) {
		JsonConfig jsconfig = new JsonConfig();
		jsconfig.setJavaIdentifierTransformer(new JavaIdentifierTransformer() {
			@Override
			public String transformToJavaIdentifier(String arg0) {
				if (arg0.equals("TSR_RESULT")) {
					return arg0;
				}
				if (arg0.equals("TSR_CODE")) {
					return arg0;
				}
				if (arg0.equals("TSR_MSG")) {
					return arg0;
				}
				char[] chars = arg0.toCharArray();
				chars[0] = Character.toLowerCase(chars[0]);
				return new String(chars);
			}
		});
		jsconfig.setRootClass(objClass);
		return jsconfig;
	}
	
	public static String getErrorJson(String errCode,String errorMsg) {
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", errCode);
		response.put("TSR_MSG", errorMsg);
		return response.toString();
	}
	
	public static JSONObject getErrorJsonObject(String errCode,String errorMsg)
	{
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", errCode);
		response.put("TSR_CODE", errCode);
		response.put("TSR_MSG", errorMsg);
		return response;
	}
	public static JSONObject getSuccessJson()
	{
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", Constant.RESULT_SUCCESS);
		response.put("TSR_CODE", Constant.RESULT_SUCCESS);
		response.put("TSR_MSG", Constant.RESULT_SUCCESS_MSG);
		return response;
	}
	
	public static JSONObject getSuccessJson(String msg)
	{
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", Constant.RESULT_SUCCESS);
		response.put("TSR_CODE", Constant.RESULT_SUCCESS);
		response.put("TSR_MSG", msg);
		return response;
	}
	public static JSONObject getEmptyContentJson()
	{
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", Constant.RESULT_EMPTY);
		response.put("TSR_CODE", Constant.RESULT_EMPTY);
		response.put("TSR_MSG", Constant.RESULT_EMPTY_MSG);
		return response;
	}
	
	/**
	 * 根据错误码信息返回JSON对象。by lifa,2013-9-16.
	 * @param errCode 错误码
	 * @param errorMsg 错误信息
	 * @return
	 */
	public static JSONObject getJsonObject(String errCode,String errorMsg){
		JSONObject response = new JSONObject();
		response.put("code", errCode);
		response.put("msg", errorMsg);
		return response;
	}
	
	
	public static void printJsonString(HttpServletResponse rsp, String jsonStr){
		rsp.setCharacterEncoding("UTF-8");
		rsp.setContentType("text/json");
		try {
			rsp.getWriter().println(jsonStr);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 返回json格式数据串。by lifa,2013-9-16.
	 * @param obj
	 * @return
	 */
	public static String returnJsonString(Object obj){
		JSON json = JSONSerializer.toJSON(obj);
		return json.toString();
	}
	
	public static String listmapToJsonString(List<Object[]> list)
	{       
		List<Map<String,Object>> tmp=new ArrayList<Map<String,Object>>();
		for(Object o:list)
		{
			tmp.add((Map<String, Object>) o);
		}
		return listmap_to_json_string(tmp);
	}
	
	public static String listmap_to_json_string(List<Map<String, Object>> list)
	{       
	    JSONArray json_arr=new JSONArray();
	    for (Map<String, Object> map : list) {
	        JSONObject json_obj=new JSONObject();
	        for (Map.Entry<String, Object> entry : map.entrySet()) {
	            String key = entry.getKey();
	            Object value = entry.getValue();
	            try {
	            	if(null==value)
	            		value="";
	                json_obj.put(key.toLowerCase(),value);
	            } catch (JSONException e) {
	                // TODO Auto-generated catch block
	                e.printStackTrace();
	            }                           
	        }
	        json_arr.element(json_obj);
	    }
	    return json_arr.toString();
	}
}
