package com.jshx.message.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.jshx.core.base.entity.BaseModel;

@SuppressWarnings("serial")
@Entity
@Table(name = "JSHX_MESSAGE")
public class JshxMessage extends BaseModel {
	private String deptCode;

	private Integer delFlag;

	
	private String messageid;
	
	/**
	 * 消息状态 0：未发送 1：发送成功 2：发送失败
	 */
	private String messagestatus;

	private String sendphone;

	private String receivephone;

	private Long repeatnum;
	
	private String branch;
	
	private String region;
	
	private String office;

	/**
	 * 是否已读 0：未读 1：已读
	 */
	private String isreaded;
	
	/** 信息内容表*/
	private JshxMessageInfo jshxMessageInfo;
	private String messageResult;
	
	private String sendDisplayName;
	private String receiveDisplayName;
	private String senderId;
	private String attachflag;

	@Column
	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	@Column(name = "MESSAGEID")
	public String getMessageid() {
		return messageid;
	}

	public void setMessageid(String messageid) {
		this.messageid = messageid;
	}

	@Column
	public Integer getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Integer delFlag) {
		this.delFlag = delFlag;
	}

	@Column(name = "MESSAGESTATUS")
	public String getMessagestatus() {
		return this.messagestatus;
	}

	public void setMessagestatus(String messagestatus) {
		this.messagestatus = messagestatus;
	}

	@Column(name = "SENDPHONE")
	public String getSendphone() {
		return this.sendphone;
	}

	public void setSendphone(String sendphone) {
		this.sendphone = sendphone;
	}

	@Column(name = "RECEIVEPHONE")
	public String getReceivephone() {
		return this.receivephone;
	}

	public void setReceivephone(String receivephone) {
		this.receivephone = receivephone;
	}

	@Column(name = "REPEATNUM")
	public Long getRepeatnum() {
		return this.repeatnum;
	}

	public void setRepeatnum(Long repeatnum) {
		this.repeatnum = repeatnum;
	}

	@Column(name = "ISREADED")
	public String getIsreaded() {
		return isreaded;
	}

	public void setIsreaded(String isreaded) {
		this.isreaded = isreaded;
	}

	@ManyToOne
	@JoinColumn(name = "MESSAGEID", insertable = false, updatable = false)
	public JshxMessageInfo getJshxMessageInfo() {
		return jshxMessageInfo;
	}

	public void setJshxMessageInfo(JshxMessageInfo jshxMessageInfo) {
		this.jshxMessageInfo = jshxMessageInfo;
	}
	public String getMessageResult() {
		return messageResult;
	}
	public void setMessageResult(String messageResult) {
		this.messageResult = messageResult;
	}
	
	@Transient
	public String getBranch() {
		return branch;
	}

	public void setBranch(String branch) {
		this.branch = branch;
	}
	@Transient
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}
	@Transient
	public String getOffice() {
		return office;
	}

	public void setOffice(String office) {
		this.office = office;
	}

	public String getSendDisplayName() {
		return sendDisplayName;
	}

	public void setSendDisplayName(String sendDisplayName) {
		this.sendDisplayName = sendDisplayName;
	}

	public String getReceiveDisplayName() {
		return receiveDisplayName;
	}

	public void setReceiveDisplayName(String receiveDisplayName) {
		this.receiveDisplayName = receiveDisplayName;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	public String getAttachflag() {
		return attachflag;
	}

	public void setAttachflag(String attachflag) {
		this.attachflag = attachflag;
	}
}
