package com.jshx.message.dao;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.message.entity.JshxMessage;

@Component("jshxMessageDao")
public class JshxMessageDao extends BaseDaoImpl {
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findMessageByPage", paraMap, page);
	}
	
	public Pagination findByPageMobile(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findMessageByPageMobile", paraMap, page);
	}

	public JshxMessage getById(String id) {
		return (JshxMessage) this.getObjectById(JshxMessage.class, id);
	}

	public void save(JshxMessage model) {
		model.setId(null);
		// 此处处理Blob对象（Blob对象不能直接insert）
		this.saveOrUpdateObject(model);
	}

	public void update(JshxMessage model) {
		this.saveOrUpdateObject(model);
	}

	public void delete(String id) {
		this.removeObjectById(JshxMessage.class, id);
	}

	public void deleteWithFlag(String id) {
		JshxMessage model = (JshxMessage) this.getObjectById(JshxMessage.class, id);
		model.setDelFlag(1);
		this.saveObject(model);
	}
	
	/**
	 * <查询信息列表>
	 * @param page
	 * @param paraMap
	 * @return
	 *
	 * 创建时间：2011-3-1
	 * 创建人：duanpf
	 * 方法描述：
	 * （参数含义说明如下）
	 */
	public List findListByMap(Map<String, Object> paraMap) {
		return this.findListByHqlId("findMessageByPage", paraMap);
	}
}
