package com.jshx.makereport.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.fawen.web.FawenAction;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.makereport.entity.Makereport;
import com.jshx.makereport.service.MakereportService;

public class MakereportAction extends BaseAction
{
	private static final Logger Logger = LoggerFactory.getLogger(MakereportAction.class);
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Makereport makereport = new Makereport();
	private List<FawenAttach> attach;

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	/**
	 * 业务类
	 */
	@Autowired
	private MakereportService makereportService;

	@Autowired
	private FawenAttachService fawenAttachService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private String allFileName;
	private String originFileName;
	private String userNames;
	private String userName;
	
	private String querySendtimeStart;
	private String querySendtimeEnd;
	
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserNames() {
		return userNames;
	}

	public void setUserNames(String userNames) {
		this.userNames = userNames;
	}

	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		User user = this.getLoginUser();
		userName = user.getDisplayName();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != makereport){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != makereport.getFilename()) && (0 < makereport.getFilename().trim().length())){
				paraMap.put("filename", "%" + makereport.getFilename().trim() + "%");
			}

			if ((null != makereport.getReferenceNumber()) && (0 < makereport.getReferenceNumber().trim().length())){
				paraMap.put("referenceNumber", "%" + makereport.getReferenceNumber().trim() + "%");
			}

			
			if (null != querySendtimeStart && !("".equals(querySendtimeStart)) )
			{
				paraMap.put("startSendtime", querySendtimeStart);
			}

			if (null != querySendtimeEnd && !("".equals(querySendtimeEnd)))
			{
				paraMap.put("endSendtime", querySendtimeEnd);
			}
			if ((null != makereport.getDeptName()) && (0 < makereport.getDeptName().trim().length())){
				paraMap.put("deptName", "%" + makereport.getDeptName().trim() + "%");
			}
			
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|filename|referenceNumber|publishedDate|abolitionDate|jianmianType|clauses|receivename|deptName|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = makereportService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	
	public void list2() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		User user = this.getLoginUser();
		userName = user.getDisplayName();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != makereport){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != makereport.getFilename()) && (0 < makereport.getFilename().trim().length())){
				paraMap.put("filename", "%" + makereport.getFilename().trim() + "%");
			}

			if ((null != makereport.getReferenceNumber()) && (0 < makereport.getReferenceNumber().trim().length())){
				paraMap.put("referenceNumber", "%" + makereport.getReferenceNumber().trim() + "%");
			}

			
			if (null != querySendtimeStart && !("".equals(querySendtimeStart)) )
			{
				paraMap.put("startSendtime", querySendtimeStart);
			}

			if (null != querySendtimeEnd && !("".equals(querySendtimeEnd)))
			{
				paraMap.put("endSendtime", querySendtimeEnd);
			}
			if ((null != makereport.getDeptName()) && (0 < makereport.getDeptName().trim().length())){
				paraMap.put("deptName", "%" + makereport.getDeptName().trim() + "%");
			}
			
		}
		
		paraMap.put("createUserID", this.getLoginUserId());
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|filename|referenceNumber|publishedDate|abolitionDate|jianmianType|clauses|receivename|deptName|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = makereportService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != makereport)&&(null != makereport.getId()))
			makereport = makereportService.getById(makereport.getId());
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", makereport.getId());
		attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		try
		{
			if("add".equals(this.flag)){
				
				if(this.getLoginUser().getLoginId().equals("admin")){
					makereport.setDeptId("4028804656bb2c8e0156bb3c37b2002c");//收费处
				}else{
					makereport.setDeptId(this.getLoginUserDepartmentId());
				}
//				if(this.getLoginUser().getLoginId().equals("admin")){
//					makereport.setDeptName("收费处");;//收费处
//				}else{
//					makereport.setDeptName(this.getLoginUserDepartment().getDeptName());
//				}
				
				makereport.setDelFlag(0);
				makereport.setReceivename(userNames);
				makereportService.save(makereport);
				// 保存公告附件
				if (StringUtil.isNotNullAndNotEmpty(allFileName))
				{
					allFileName = allFileName.substring(0, allFileName.length() - 1);
					originFileName = originFileName.substring(0, originFileName.length() - 1);
					String[] arr = allFileName.split(",");
					String[] oriArr = originFileName.split(",");
					for (int i = 0; i < arr.length; i++)
					{
						FawenAttach att = new FawenAttach();
						att.setDelFlag(0);
						att.setAttachname(oriArr[i].trim());
						att.setAttachpath(arr[i].trim());
						att.setBizrowid(makereport.getId());
						att.setCreateTime(new Date());
						fawenAttachService.save(att);
					}

				}
			}else{
				makereportService.update(makereport);
				
				Map<String, String> paramMap = new HashMap<String, String>();
				paramMap.put("bizrowid", makereport.getId());
				attach= fawenAttachService.queryAttachListByTempleId(paramMap);
				
				for(FawenAttach fa:attach){
					fawenAttachService.deleteWithFlag(fa.getId());
				}
				
				if (StringUtil.isNotNullAndNotEmpty(allFileName))
				{
					allFileName = allFileName.substring(0, allFileName.length() - 1);
					originFileName = originFileName.substring(0, originFileName.length() - 1);
					String[] arr = allFileName.split(",");
					String[] oriArr = originFileName.split(",");
					for (int i = 0; i < arr.length; i++)
					{
						FawenAttach att = new FawenAttach();
						att.setDelFlag(0);
						att.setAttachname(oriArr[i].trim());
						att.setAttachpath(arr[i].trim());
						att.setBizrowid(makereport.getId());
						att.setCreateTime(new Date());
						fawenAttachService.save(att);
					}

				}
			}
			
			
		}catch(Exception e)
		{
			logger.error(e.toString());
		}
	
		
		
		return RELOAD;
	}



	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			makereportService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Makereport getMakereport(){
		return this.makereport;
	}

	public void setMakereport(Makereport makereport){
		this.makereport = makereport;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getQuerySendtimeStart() {
		return querySendtimeStart;
	}

	public void setQuerySendtimeStart(String querySendtimeStart) {
		this.querySendtimeStart = querySendtimeStart;
	}

	public String getQuerySendtimeEnd() {
		return querySendtimeEnd;
	}

	public void setQuerySendtimeEnd(String querySendtimeEnd) {
		this.querySendtimeEnd = querySendtimeEnd;
	}
       
    
    
}
