package com.jshx.lxrinfo.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.dao.LxrinfoDao;

@Component("lxrinfoDao")
public class LxrinfoDaoImpl extends BaseDaoImpl implements LxrinfoDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findLxrinfoByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findLxrinfo(Map<String, Object> paraMap){
		return this.findListByHqlId("findLxrinfoByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Lxrinfo getById(String id)
	{
		return (Lxrinfo)this.getObjectById(Lxrinfo.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Lxrinfo lxrinfo)
	{
		lxrinfo.setId(null);
		this.saveOrUpdateObject(lxrinfo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Lxrinfo lxrinfo)
	{
		this.saveOrUpdateObject(lxrinfo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Lxrinfo.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Lxrinfo lxrinfo = (Lxrinfo)this.getObjectById(Lxrinfo.class, id);
		lxrinfo.setDelFlag(1);
		this.saveObject(lxrinfo);
	}
}
