package com.jshx.lsfc.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.common.utils.ValidUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.lsfc.entity.Lsfc;
import com.jshx.lsfc.service.LsfcService;

public class LsfcAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Lsfc lsfc = new Lsfc();

	/**
	 * 业务类
	 */
	@Autowired
	private LsfcService lsfcService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	private File importFile;
	
	private String startTime;
	
	private String endTime;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != lsfc){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != lsfc.getZsdw()) && (0 < lsfc.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + lsfc.getZsdw().trim() + "%");
			}

			if ((null != lsfc.getXmmc()) && (0 < lsfc.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + lsfc.getXmmc().trim() + "%");
			}
			if ((null != lsfc.getDah()) && (0 < lsfc.getDah().trim().length())){
				paraMap.put("dah", "%" + lsfc.getDah().trim() + "%");
			}

			if ((null != lsfc.getXmdz()) && (0 < lsfc.getXmdz().trim().length())){
				paraMap.put("xmdz", "%" + lsfc.getXmdz().trim() + "%");
			}
			if ((null != lsfc.getZjmj()) && (0 < lsfc.getZjmj().trim().length())){
				paraMap.put("zjmj", "%" + lsfc.getZjmj().trim() + "%");
			}

			if ((null != lsfc.getBllb()) && (0 < lsfc.getBllb().trim().length())){
				paraMap.put("bllb", "%" + lsfc.getBllb().trim() + "%");
			}

			if (null != startTime&&!("".equals(startTime))){
				paraMap.put("startTime", startTime);
			}

			if (null != endTime&&!("".equals(endTime))){
				paraMap.put("endTime", endTime);
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|zsdw|dwdz|xmdz|xmmc|bllb|dqlb|spxx|zjmj|zjdz|jxyf|ywyf|yyyf|fsyf|scyf|yjje|ymje|awj|abwd|hj1|cd1|sc1|sfrq|sfhj|dah|bz1|cfwz|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = lsfcService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != lsfc)&&(null != lsfc.getId()))
			lsfc = lsfcService.getById(lsfc.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if (null != importFile) {
		String message = null;
		Workbook workBook = null;
		try {
			try {
				workBook = Workbook.getWorkbook(importFile);
			} catch (Exception e) {
				message = "解析上传文件信息异常,请检查.";
			}

			if (null == workBook) {
				message = "打开上传文件信息失败,请检查.";
			}

			try {
				Sheet[] sheets = workBook.getSheets();
				if (null == sheets || 0 == sheets.length) {
					message = "上传文件工作薄信息为空,请检查.";
				}
				Sheet sheet = sheets[1];
				Cell[] cells;
				long rowCount = ValidUtils.getRealRows(sheet, sheet.getRows(), sheet.getColumns());
				if (rowCount <= 1) {
					message = "上传文件中无数据,请检查.";
				}
				List<Lsfc> list1 = new ArrayList<Lsfc>();
				for (int i = 1; i < rowCount; i++) {
					Lsfc bean = null;
					cells = sheet.getRow(i);
					if (null == cells || cells.length == 0) {
						continue;
					}
					bean = new Lsfc();
					bean.setCreateTime(new Date());
					bean.setDeptId(this.getLoginUserDepartmentId());
					bean.setDelFlag(0);
					bean.setId("");
					bean.setCreateUserID("");
					bean.setUpdateUserID("");
					//原始表导入状态,0:导入未划分,1:已整合入项目基础表,2:与已整合的信息编号相同,999:异常代码
					
					if(null==cells[0].getContents().trim()){
						bean.setZsdw("");
					}else{
						bean.setZsdw(cells[0].getContents().trim());
					}
					
					if(null==cells[1].getContents().trim()){
						bean.setDwdz("");
					}else{	
						bean.setDwdz(cells[1].getContents().trim());
					}	

					if(null==cells[2].getContents().trim()){
						bean.setXmdz("");
					}else{
					bean.setXmdz(cells[2].getContents().trim());
					}
					
					if(null==cells[3].getContents().trim()){
						bean.setXmmc("");
					}else{
					bean.setXmmc(cells[3].getContents().trim());
					}
					
					
					if(null==cells[4].getContents().trim()){
						bean.setBllb("");
					}else{
						bean.setBllb(cells[4].getContents().trim());
					}
					
					
					if(null==cells[5].getContents().trim()){
						bean.setDqlb("");
					}else{
					bean.setDqlb(cells[5].getContents().trim());
					}
					
					if(null==cells[6].getContents().trim()){
						bean.setSpxx("");
					}else{
					bean.setSpxx(cells[6].getContents().trim());
					
					}
					
					if(null==cells[7].getContents().trim()){
						bean.setZjmj("");
					}else{
						bean.setZjmj(cells[7].getContents().trim());
					}
					
					if(null==cells[8].getContents().trim()){
						bean.setZjdz("");
					}else{
					bean.setZjdz(cells[8].getContents().trim());
					}
					
					if(null==cells[9].getContents().trim()){
						bean.setJxyf("");
					}else{
					bean.setJxyf(cells[9].getContents().trim());
					}
					
					
					if(null==cells[10].getContents().trim()){
						bean.setYwyf("");
					}else{
					bean.setYwyf(cells[10].getContents().trim());
					}
					
					if(null==cells[11].getContents().trim()){
						bean.setYyyf("");
					}else{
					bean.setYyyf(cells[11].getContents().trim());
					}
					
					if(null==cells[12].getContents().trim()){
						bean.setFsyf("");
					}else{
					bean.setFsyf(cells[12].getContents().trim());
					}
					
					
					if(null==cells[13].getContents().trim()){
						bean.setScyf("");
					}else{
					bean.setScyf(cells[13].getContents().trim());
					}
					
					if(null==cells[14].getContents().trim()){
						bean.setYjje("");
					}else{
						bean.setYjje(cells[14].getContents().trim());
					}
					
					if(null==cells[15].getContents().trim()){
						bean.setYmje("");
					}else{
					bean.setYmje(cells[15].getContents().trim());
					}
					
					if(null==cells[16].getContents().trim()){
						bean.setAwj("");
					}else{
					bean.setAwj(cells[16].getContents().trim());
					}
					
					if(null==cells[17].getContents().trim()){
						bean.setAbwd("");
					}else{
					bean.setAbwd(cells[17].getContents().trim());
					}
					
					if(null==cells[18].getContents().trim()){
						bean.setHj1("");
					}else{
					bean.setHj1(cells[18].getContents().trim());
					}
					
					
					if(null==cells[19].getContents().trim()){
						bean.setCd1("");
					}else{
					bean.setCd1(cells[19].getContents().trim());
					}
					
					if(null==cells[20].getContents().trim()){
						bean.setSc1("");
					}else{
					bean.setSc1(cells[20].getContents().trim());
					}
					
					if(null==cells[21].getContents().trim()){
						bean.setSfrq("");
					}else{
					bean.setSfrq(cells[21].getContents().trim());
					
					}
					
					if(null==cells[22].getContents().trim()){
						bean.setSfhj("");
					}else{
					bean.setSfhj(cells[22].getContents().trim());
					}
					
					if(null==cells[23].getContents().trim()){
						bean.setDah("");
					}else{
					bean.setDah(cells[23].getContents().trim());
					}
					if(null==cells[24].getContents().trim()){
						bean.setBz1("");
					}else{
					bean.setBz1(cells[24].getContents().trim());
					}
					if(null==cells[0].getContents().trim()){
						bean.setCfwz("");
					}else{
					bean.setCfwz(cells[25].getContents().trim());
					}
			

					list1.add(bean);
				}

				if (null != list1 && list1.size() > 0) {

					for (Lsfc bean : list1) {
						lsfcService.save(bean);
					}
				}

			} catch (Exception ex) {
				message = "出错了！" + ex.getMessage();
			}
		} catch (Exception e) {
			workBook.close();
		}
		if (null != message) {
			this.getRequest().setAttribute("message", message);
		}
		workBook.close();
	} else {
		this.getRequest().setAttribute("message", "获取上传文件信息失败,请重新上传文件.");
	}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != lsfc)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到lsfc中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			lsfcService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Lsfc getLsfc(){
		return this.lsfc;
	}

	public void setLsfc(Lsfc lsfc){
		this.lsfc = lsfc;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public File getImportFile() {
		return importFile;
	}

	public void setImportFile(File importFile) {
		this.importFile = importFile;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}
       
    
}
