package com.jshx.kjkmb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.kjkmb.entity.Kjkmb;
import com.jshx.kjkmb.dao.KjkmbDao;

@Component("kjkmbDao")
public class KjkmbDaoImpl extends BaseDaoImpl implements KjkmbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findKjkmbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findKjkmb(Map<String, Object> paraMap){
		return this.findListByHqlId("findKjkmbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Kjkmb getById(String id)
	{
		return (Kjkmb)this.getObjectById(Kjkmb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Kjkmb kjkmb)
	{
		kjkmb.setId(null);
		this.saveOrUpdateObject(kjkmb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Kjkmb kjkmb)
	{
		this.saveOrUpdateObject(kjkmb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Kjkmb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Kjkmb kjkmb = (Kjkmb)this.getObjectById(Kjkmb.class, id);
		kjkmb.setDelFlag(1);
		this.saveObject(kjkmb);
	}
}
