package com.jshx.jtqd.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jtqd.dao.JtqdDao;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.service.JtqdService;

@Service("jtqdService")
public class JtqdServiceImpl extends BaseServiceImpl implements JtqdService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jtqdDao")
	private JtqdDao jtqdDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jtqdDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jtqd getById(String id)
	{
		return jtqdDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Jtqd jtqd)
	{
		jtqdDao.save(jtqd);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Jtqd jtqd)
	{
		jtqdDao.update(jtqd);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jtqdDao.findJtqd(paraMap);
		
		jtqdDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jtqdDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Jtqd getByslbh(String slbh) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", slbh);
		paraMap.put("delFlag", 0);
		Jtqd Jtqd = 	(Jtqd) jtqdDao.findObjectByFieldsMap(Jtqd.class, paraMap);
		return Jtqd;
	}

	@Override
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap) {
		return jtqdDao.findByPage1(page, paraMap);
	}

	@Override
	public Jtqd getBySequenctId(String sequenctId) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("sequenceId", sequenctId);
		paraMap.put("delFlag", 0);
		Jtqd Jtqd = 	(Jtqd) jtqdDao.findObjectByFieldsMap(Jtqd.class, paraMap);
		return Jtqd;
	}
}
