package com.jshx.hsdmj.web;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hscmj.entity.Hscmj;
import com.jshx.hscmj.service.HscmjService;
import com.jshx.hsdmj.entity.Hsdmj;
import com.jshx.hsdmj.entity.Hsdmj2;
import com.jshx.hsdmj.service.HsdmjService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HsdmjAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hsdmj hsdmj = new Hsdmj();

	private List<Hsdmj2> dmj = new ArrayList<Hsdmj2>();

	private List<List<Hscmj>> hscmj = new ArrayList<List<Hscmj>>();

	/**
	 * 业务类
	 */
	@Autowired
	private HsdmjService hsdmjService;
	@Autowired
	private HscmjService hscmjService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hsdmj)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hsdmj.getXmbzj()) && (0 < hsdmj.getXmbzj().trim().length()))
			{
				paraMap.put("xmbzj", "%" + hsdmj.getXmbzj().trim() + "%");
			}

			if ((null != hsdmj.getSlbh()) && (0 < hsdmj.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + hsdmj.getSlbh().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xmcc|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hsdmjService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hsdmj) && (null != hsdmj.getId()))
			hsdmj = hsdmjService.getById(hsdmj.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	public String save() throws Exception
	{
		try
		{

			if (null != hsdmj && null != hsdmj.getSlbh())
			{
				String slbh = hsdmj.getSlbh();
				hsdmjService.delBySlbh(slbh);
				hscmjService.delBySlbh(slbh);
				for (Hsdmj2 dmjs : dmj)
				{
					if (dmjs == null)
						continue;
					String donghao = dmjs.getDonghao();
					String dsmj = dmjs.getDsmj();
					String dxmj = dmjs.getDxmj();
					String ddmj = dmjs.getDdmj();
					Hsdmj hs = new Hsdmj();
					BeanUtils.copyProperties(hsdmj, hs);
//					System.out.println("栋号:" + donghao + "-地上面积:" + dsmj + "-地下面积:" + dxmj + "-单栋面积:" + ddmj);
					hs.setDonghao(donghao);
					hs.setDsmj(dsmj);
					hs.setDxmj(dxmj);
					hs.setDdmj(ddmj);
					hs.setDelFlag(0);
					hsdmjService.save(hs);
					List<Hscmj> list = dmjs.getHscmjs();
//					System.out.println("fioor" + list.size());
					for (Hscmj hscmj : list)
					{
						if (hscmj == null)
							continue;
						hscmj.setDmjzj(hs.getId());
						hscmj.setSlbh(hsdmj.getSlbh());
						hscmj.setDelFlag(0);
						hscmjService.save(hscmj);
//						System.out.println("hscId" + hscmj.getId());
//						System.out.println("层数:" + hscmj.getCengshu() + "-面积:" + hscmj.getMianji());
					}

				}
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
		
		
//		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hsdmj)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hsdmj中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hsdmjService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hsdmj getHsdmj()
	{
		return this.hsdmj;
	}

	public void setHsdmj(Hsdmj hsdmj)
	{
		this.hsdmj = hsdmj;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public List<Hsdmj2> getDmj()
	{
		return dmj;
	}

	public void setDmj(List<Hsdmj2> dmj)
	{
		this.dmj = dmj;
	}

	public List<List<Hscmj>> getHscmj()
	{
		return hscmj;
	}

	public void setHscmj(List<List<Hscmj>> hscmj)
	{
		this.hscmj = hscmj;
	}
}
